<?php defined('BASEPATH') or exit('No direct script access allowed');

class Bill extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        is_logged_in();
        $this->load->model(['customer_m', 'package_m', 'services_m', 'setting_m', 'bill_m', 'income_m']);
    }

    public function index()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['show_bill'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Bill';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomeractive()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['invoice'] =  $this->bill_m->invoice_no();
        $data['coverage'] = $this->db->get('coverage')->result();
        $data['other'] = $this->db->get('other')->row_array();
        $this->template->load('backend', 'backend/bill/bill', $data);
    }
    public function draf()
    {
        $data['title'] = 'Bill Draf';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomerActive()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['other'] = $this->db->get('other')->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/bill/draf', $data);
    }
    public function drafselected()
    {
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Bill Draf';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomerActive()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['other'] = $this->db->get('other')->row_array();
        $data['month'] = $post['month'];
        $data['year'] = $post['year'];
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/bill/drafselected', $data);
    }

    public function filter()
    {

        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Bill';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['bill'] = $this->bill_m->getInvoiceFilter($post)->result();
        $data['detail'] = $this->bill_m->getInvoiceDetail()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['coverage'] = $this->db->get('coverage')->result();
        $this->template->load('backend', 'backend/bill/billFilter', $data);
    }
    public function filterunpaid()
    {
        if ($this->input->post('month') <= 0) {
            echo "<script>window.location='" . site_url('bill/unpaid') . "'; </script>";
        }
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Belum Bayar';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['bill'] = $this->bill_m->getInvoiceFilterUnpaid($post)->result();
        $data['detail'] = $this->bill_m->getInvoiceDetail()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/bill/unpaid', $data);
    }
    public function filterpaid()
    {
        if ($this->input->post('month') <= 0) {
            echo "<script>window.location='" . site_url('bill/paid') . "'; </script>";
        }
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Sudah Bayar';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['bill'] = $this->bill_m->getInvoiceFilterpaid($post)->result();
        $data['detail'] = $this->bill_m->getInvoiceDetail()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/bill/paid', $data);
    }
    public function unpaid()
    {
        $data['title'] = 'Belum Bayar';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomeractive()->result();
        $data['bill'] = $this->bill_m->getInvoiceUp()->result();
        $data['detail'] = $this->bill_m->getInvoiceDetail()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $this->template->load('backend', 'backend/bill/unpaid', $data);
    }
    public function paid()
    {
        $data['title'] = 'Sudah Bayar';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['bill'] = $this->bill_m->getInvoiceP()->result();
        $data['detail'] = $this->bill_m->getInvoiceDetail()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $this->template->load('backend', 'backend/bill/paid', $data);
    }


    public function view_data()
    {
        if (isset($_POST['cek_data'])) {
            $data['services'] =  $this->services_m->getServicesDetail($this->input->post('no_services'));
            $this->load->view('backend/bill/detail_bill', $data);
        } else {
            echo "cek";
        }
    }



    public function addBill()
    {

        $data = $this->input->post(null, TRUE);
        $no_services = $this->input->post('no_services');
        $month = $this->input->post('month');
        $year = $this->input->post('year');
        $cekperiode = $this->bill_m->cekPeriode($no_services, $month, $year);
        $inv = $this->input->post('invoice');
        $getInv = $this->bill_m->getRecentInv()->row();
        $cekCustomer = $this->db->get_where('customer', ['no_services' => $no_services])->row_array();
        if ($cekCustomer['ppn'] > 0) {
            $ppn = 10;
        } else {
            $ppn = 0;
        }

        $cekinvoice = $this->bill_m->cekInvoice($inv);
        $getInv = $this->bill_m->getRecentInv()->row();
        if ($cekinvoice->num_rows() > 0) {
            $invoice = $getInv->invoice + 1;
        } else {
            $invoice = $this->input->post('invoice');
        }
        $query = "SELECT *
        FROM `services` where `no_services` = $no_services";
        $bill = $this->db->query($query)->result();
        $amountt = 0;
        foreach ($bill as $bill) {
            $amountt += (int) $bill->total;
        }
        $amount = $amountt + $amountt * ($ppn / 100);
        $this->load->library('ciqrcode'); //pemanggilan library QR CODE
        $config['cacheable']    = true; //boolean, the default is true
        $config['cachedir']     = './assets/'; //string, the default is application/cache/
        $config['errorlog']     = './assets/'; //string, the default is application/logs/
        $config['imagedir']     = './assets/images/qrcode/'; //direktori penyimpanan qr code
        $config['quality']      = true; //boolean, the default is true
        $config['size']         = '1024'; //interger, the default is 1024
        $config['black']        = array(224, 255, 255); // array, default is array(255,255,255)
        $config['white']        = array(70, 130, 180); // array, default is array(0,0,0)
        $this->ciqrcode->initialize($config);
        $image_name = $invoice . '.png'; //buat name dari qr code
        $params['data'] = $invoice . '-' . $no_services; //data yang akan di jadikan QR CODE
        $params['level'] = 'H'; //H=High
        $params['size'] = 10;
        $params['savename'] = FCPATH . $config['imagedir'] . $image_name; //simpan image QR CODE ke folder assets/images/
        $this->ciqrcode->generate($params); // fungsi untuk generate QR CODE
        if ($cekperiode->num_rows() > 0) {
            $this->session->set_flashdata('error', 'Gagal, Tagihan untuk periode tersebut sudah tersedia, mohon dicek kembali !');
            redirect($_SERVER['HTTP_REFERER']);
        } else {
            $this->bill_m->addBill($data, $invoice, $ppn, $amount);
            $Detail = $this->services_m->getServicesDetail($this->input->post('no_services'))->result();
            $data2 = [];
            foreach ($Detail as $c => $row) {
                array_push(
                    $data2,
                    array(
                        'invoice_id' => $invoice,
                        'item_id' => $row->item_id,
                        'category_id' => $row->category_id,
                        'price' => $row->services_price,
                        'qty' => $row->qty,
                        'disc' => $row->disc,
                        'remark' => $row->remark,
                        'total' => $row->total,
                        'd_month' => $month,
                        'd_year' => $year,
                        'd_no_services' => $row->no_services,
                    )
                );
            }
            $this->bill_m->add_bill_detail($data2);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Tagihan berhasil dibuat');
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
    }
    public function addBillDraf()
    {
        $data = $this->input->post(null, TRUE);
        $no_services = $this->input->post('no_services');
        $getInv = $this->bill_m->getRecentInv()->row();
        $month = $this->input->post('month');
        $year = $this->input->post('year');
        $tgl = date('ymd');
        $no = 001;
        if ($getInv->invoice == 0) {
            $invoice = ($tgl . '' .  str_pad($no, 3, "0", STR_PAD_LEFT));
        } else {
            $invoice = $getInv->invoice + 1;
        }
        $cekperiode = $this->bill_m->cekPeriode($no_services, $month, $year);

        $cekCustomer = $this->db->get_where('customer', ['no_services' => $no_services])->row_array();
        if ($cekCustomer['ppn'] > 0) {
            $ppn = 10;
        } else {
            $ppn = 0;
        }

        $query = "SELECT *
        FROM `services` where `no_services` = $no_services";
        $bill = $this->db->query($query)->result();
        $amountt = 0;
        foreach ($bill as $bill) {
            $amountt += (int) $bill->total;
        }
        $amount = $amountt + $amountt * ($ppn / 100);
        $this->load->library('ciqrcode'); //pemanggilan library QR CODE
        $config['cacheable']    = true; //boolean, the default is true
        $config['cachedir']     = './assets/'; //string, the default is application/cache/
        $config['errorlog']     = './assets/'; //string, the default is application/logs/
        $config['imagedir']     = './assets/images/qrcode/'; //direktori penyimpanan qr code
        $config['quality']      = true; //boolean, the default is true
        $config['size']         = '1024'; //interger, the default is 1024
        $config['black']        = array(224, 255, 255); // array, default is array(255,255,255)
        $config['white']        = array(70, 130, 180); // array, default is array(0,0,0)
        $this->ciqrcode->initialize($config);
        $image_name = $invoice . '.png'; //buat name dari qr code
        $params['data'] = $invoice . '-' . $no_services; //data yang akan di jadikan QR CODE
        $params['level'] = 'H'; //H=High
        $params['size'] = 10;
        $params['savename'] = FCPATH . $config['imagedir'] . $image_name; //simpan image QR CODE ke folder assets/images/
        $this->ciqrcode->generate($params); // fungsi untuk generate QR CODE
        if ($cekperiode->num_rows() > 0) {
            $this->session->set_flashdata('error', 'Gagal, Tagihan untuk periode tersebut sudah tersedia, mohon dicek kembali !');
            redirect($_SERVER['HTTP_REFERER']);
        } else {
            $this->bill_m->addBill($data, $invoice, $ppn, $amount);
            $Detail = $this->services_m->getServicesDetail($this->input->post('no_services'))->result();
            $data2 = [];
            foreach ($Detail as $c => $row) {
                array_push(
                    $data2,
                    array(
                        'invoice_id' => $invoice,
                        'item_id' => $row->item_id,
                        'category_id' => $row->category_id,
                        'price' => $row->services_price,
                        'qty' => $row->qty,
                        'disc' => $row->disc,
                        'remark' => $row->remark,
                        'total' => $row->total,
                        'd_month' => $month,
                        'd_year' => $year,
                        'd_no_services' => $row->no_services,
                    )
                );
            }
            $this->bill_m->add_bill_detail($data2);

            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Tagihan berhasil dibuat');
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
    }
    public function generateBill()
    {
        $no_services = $this->customer_m->getCustomerActive()->result();
        $month = $this->input->post('month');
        $year = $this->input->post('year');
        $inv = $this->input->post('invoice');
        $cekperiode = $this->bill_m->cekPeriodeMonth($month, $year);
        $cekinvoice = $this->bill_m->cekInvoice($inv);
        $getInv = $this->bill_m->getRecentInv()->row();
        if ($cekinvoice->num_rows() > 0) {
            $kode = $getInv->invoice + 1;
        } else {
            $tgl = date('ymd');
            $no = 001;
            $kode = ($tgl . '' .  str_pad($no, 3, "0", STR_PAD_LEFT));
        }

        if ($cekperiode->num_rows() > 0) {
            $this->session->set_flashdata('error', 'Gagal, Tagihan untuk periode ini sudah tersedia disalah satu pelanggan, mohon dicek kembali !');
            redirect($_SERVER['HTTP_REFERER']);
        } else {

            $dataNS = [];
            foreach ($no_services as $c => $row) {
                if ($row->ppn != 0) {
                    $ppn = 10;
                } else {
                    $ppn = 0;
                }
                $query = "SELECT *
                FROM `services` where `no_services` = $row->no_services";
                $bill = $this->db->query($query)->result();
                $amountt = 0;
                foreach ($bill as $bill) {
                    $amountt += (int) $bill->total;
                }
                $amount = $amountt + $amountt * ($ppn / 100);
                array_push(
                    $dataNS,
                    array(
                        'no_services' => $row->no_services,
                        'invoice' => $kode++,
                        'month' => $month,
                        'i_ppn' => $ppn,
                        'amount' => $amount,
                        'year' => $year,
                        'code_unique' => substr(intval(rand()), 0, 3),
                        'status' => 'BELUM BAYAR',
                        'created' => time()
                    )
                );
            }
            $this->bill_m->add_bill_generate($dataNS);
            $detail = $this->services_m->getServicesActive()->result();
            $data2 = [];
            foreach ($detail as $c => $row) {
                array_push(
                    $data2,
                    array(
                        // 'invoice_id' => $kode1++,
                        'item_id' => $row->item_id,
                        'category_id' => $row->category_id,
                        'price' => $row->services_price,
                        'qty' => $row->qty,
                        'disc' => $row->disc,
                        'remark' => $row->remark,
                        'total' => $row->total,
                        'd_month' => $month,
                        'd_year' => $year,
                        'd_no_services' => $row->no_services,
                    )
                );
            }
            $this->bill_m->add_bill_detail($data2);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Generate Tagihan berhasil dibuat');
            }
            redirect('bill/unpaid');
        }
    }
    public function generateselected()
    {
        $noservices = $_POST['noservices'];

        if ($noservices == null) {
            $this->session->set_flashdata('error', 'Tagihan belum dipilih');
            redirect('bill/draf');
        } else {
            $no_services = $this->customer_m->getCustomerSelecteddraf($noservices)->result();
            // var_dump($no_services);
            // die;
            $month = $this->input->post('month');
            $year = $this->input->post('year');
            $getInv = $this->bill_m->getRecentInv()->row();
            $tgl = date('ymd');
            $no = 001;
            if ($getInv->invoice == 0) {
                $kode = ($tgl . '' .  str_pad($no, 3, "0", STR_PAD_LEFT));
            } else {
                $kode = $getInv->invoice + 1;
            }
            $dataNS = [];
            foreach ($no_services as $c => $row) {

                if ($row->ppn != 0) {
                    $ppn = 10;
                } else {
                    $ppn = 0;
                }
                $query = "SELECT *
                FROM `services` where `no_services` = $row->no_services";
                $bill = $this->db->query($query)->result();
                $amountt = 0;
                foreach ($bill as $bill) {
                    $amountt += (int) $bill->total;
                }
                $amount = $amountt + $amountt * ($ppn / 100);
                array_push(
                    $dataNS,
                    array(
                        'no_services' => $row->no_services,
                        'invoice' => $kode++,
                        'month' => $month,
                        'i_ppn' => $ppn,
                        'amount' => $amount,
                        'year' => $year,
                        'code_unique' => substr(intval(rand()), 0, 3),
                        'status' => 'BELUM BAYAR',
                        'created' => time()
                    )
                );
            }
            $this->bill_m->add_bill_generate($dataNS);
            $detail = $this->services_m->getServicesActiveSelected($noservices)->result();
            $data2 = [];
            foreach ($detail as $c => $row) {
                array_push(
                    $data2,
                    array(
                        // 'invoice_id' => $kode1++,
                        'item_id' => $row->item_id,
                        'category_id' => $row->category_id,
                        'price' => $row->services_price,
                        'qty' => $row->qty,
                        'disc' => $row->disc,
                        'remark' => $row->remark,
                        'total' => $row->total,
                        'd_month' => $month,
                        'd_year' => $year,
                        'd_no_services' => $row->no_services,
                    )
                );
            }


            $this->bill_m->add_bill_detail($data2);

            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Generate Tagihan yang dipilih berhasil dibuat');
            }
            redirect('bill/unpaid');
        }
    }


    public function detail($invoice)
    {
        $data['title'] = 'Detail Bill';
        $data['invoice'] = $this->bill_m->getEditInvoice($invoice);
        $data['p_item'] = $this->package_m->getPItem()->result();
        $data['bill'] = $this->bill_m->getBill($invoice)->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $this->template->load('backend', 'backend/bill/invoice_detail', $data);
    }

    public function donation()
    {
        $data['title'] = 'Donasi';
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $this->template->load('backend', 'backend/bill/donation', $data);
    }
    public function view_donation()
    {
        $month = $this->input->post('month');
        $year = $this->input->post('year');
        if (isset($_POST['cek_bill'])) {
            $data['bill'] = $this->bill_m->getInvoiceThisMonth($month, $year)->result();
            $this->load->view('backend/bill/tampil_donation', $data);
        } else {
            echo "Not Found";
        }
    }
    public function delete()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['del_bill'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('dashboard');
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);
        $invoice = $this->input->post('invoice');
        $cekConfir = $this->db->get_where('confirm_payment', ['invoice_id' => $invoice])->row_array();
        $cekIncome = $this->db->get_where('income', ['invoice_id' => $invoice])->row_array();
        if ($cekConfir > 0) {
            $this->session->set_flashdata('error', 'Tagihan tidak bisa dihapus dikarenakan masih ada di konfirmasi pembayaran');
        } elseif ($cekIncome > 0) {
            $this->session->set_flashdata('error', 'Tagihan tidak bisa dihapus dikarenakan masih ada di data pendapadatan');
            # code...
        } else {
            $this->bill_m->delete($invoice);
            $this->bill_m->deleteDetailInvoice($invoice);
            $this->bill_m->deleteDetailBill($post);
            $target_file = './assets/images/qrcode/' . $invoice . '.png';
            unlink($target_file);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data Tagihan berhasil dihapus');
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }



    public function printinvoice($invoice)
    {
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['invoice'] = $this->bill_m->getBill($invoice);
        $data['invoice_detail'] = $this->bill_m->getDetailBill($invoice);
        $data['bill'] = $this->bill_m->getBill($invoice)->row_array();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();
        $data['other'] = $this->db->get('other')->row_array();
        $this->load->library('ciqrcode'); //pemanggilan library QR CODE
        $config['cacheable']    = true; //boolean, the default is true
        $config['cachedir']     = './assets/'; //string, the default is application/cache/
        $config['errorlog']     = './assets/'; //string, the default is application/logs/
        $config['imagedir']     = './assets/images/qrcode/'; //direktori penyimpanan qr code
        $config['quality']      = true; //boolean, the default is true
        $config['size']         = '1024'; //interger, the default is 1024
        $config['black']        = array(224, 255, 255); // array, default is array(255,255,255)
        $config['white']        = array(70, 130, 180); // array, default is array(0,0,0)
        $inv = $this->db->get_where('invoice', ['invoice' => $invoice])->row_array();
        $this->ciqrcode->initialize($config);
        $image_name = $invoice . '.png'; //buat name dari qr code
        $params['data'] = $invoice . '-' . $inv['no_services']; //data yang akan di jadikan QR CODE
        $params['level'] = 'H'; //H=High
        $params['size'] = 10;
        $params['savename'] = FCPATH . $config['imagedir'] . $image_name; //simpan image QR CODE ke folder assets/images/
        $this->ciqrcode->generate($params); // fungsi untuk generate QR CODE
        $this->load->view('backend/bill/invoice', $data);
    }
    public function printinvoicethermal($invoice)
    {
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['invoice'] = $this->bill_m->getBill($invoice);
        $data['invoice_detail'] = $this->bill_m->getDetailBill($invoice);
        $data['bill'] = $this->bill_m->getBill($invoice)->row_array();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();
        $data['other'] = $this->db->get('other')->row_array();
        $this->load->view('backend/bill/invoiceThermal', $data);
    }
    public function printinvoiceselected()
    {
        $invoice = $_POST['invoice'];
        if ($invoice == null) {
            $this->session->set_flashdata('error', 'Tagihan belum dipilih');
            redirect($_SERVER['HTTP_REFERER']);
        } else {
            $data['title'] = 'Invoice';
            $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
            $data['company'] = $this->db->get('company')->row_array();
            $data['invoice'] = $this->bill_m->getBill($invoice)->result();
            $data['invoice_detail'] = $this->bill_m->getBill($invoice)->result();
            $data['bill'] = $this->bill_m->getInvoiceSelected($invoice)->result();
            $data['other'] = $this->db->get('other')->row_array();
            $data['bank'] = $this->setting_m->getBank()->result();
            $data['p_item'] = $this->package_m->getPItem()->result();
            $this->load->view('backend/bill/invoiceselected', $data);
        }
    }
    public function printinvoiceselectedthermal()
    {
        $invoice = $_POST['invoice'];
        if ($invoice == null) {
            $this->session->set_flashdata('error', 'Tagihan belum dipilih');
            redirect($_SERVER['HTTP_REFERER']);
        } else {
            $data['title'] = 'Invoice';
            $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
            $data['company'] = $this->db->get('company')->row_array();
            $data['invoice'] = $this->bill_m->getBill($invoice)->result();
            $data['invoice_detail'] = $this->bill_m->getBill($invoice)->result();
            $data['bill'] = $this->bill_m->getInvoiceSelected($invoice)->result();
            $data['other'] = $this->db->get('other')->row_array();
            $data['bank'] = $this->setting_m->getBank()->result();
            $data['p_item'] = $this->package_m->getPItem()->result();
            $this->load->view('backend/bill/invoiceselectedthermal', $data);
        }
    }
    public function printinvoiceselectedsmall()
    {
        $invoice = $_POST['invoice'];
        if ($invoice == null) {
            $this->session->set_flashdata('error', 'Tagihan belum dipilih');
            redirect($_SERVER['HTTP_REFERER']);
        } else {
            $data['title'] = 'Invoice';
            $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
            $data['company'] = $this->db->get('company')->row_array();
            $data['invoice'] = $this->bill_m->getBill($invoice)->result();
            $data['invoice_detail'] = $this->bill_m->getBill($invoice)->result();
            $data['bill'] = $this->bill_m->getInvoiceSelected($invoice)->result();
            $data['other'] = $this->db->get('other')->row_array();
            $data['bank'] = $this->setting_m->getBank()->result();
            $data['p_item'] = $this->package_m->getPItem()->result();
            $this->load->view('backend/bill/invoiceselectedsmall', $data);
        }
    }
    public function printinvoiceunpaid()
    {
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['bill'] = $this->bill_m->getInvoiceUnpaid()->result();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();
        $this->load->view('backend/bill/invoiceselected', $data);
    }
    public function printinvoiceunpaidthermal()
    {
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['bill'] = $this->bill_m->getInvoiceUnpaid()->result();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();
        $this->load->view('backend/bill/invoiceselectedthermal', $data);
    }
    public function printinvoicepaid()
    {
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['bill'] = $this->bill_m->getInvoicePaid()->result();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();
        $this->load->view('backend/bill/invoiceselected', $data);
    }
    public function printinvoicepaidthermal()
    {
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['bill'] = $this->bill_m->getInvoicePaid()->result();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();
        $this->load->view('backend/bill/invoiceselectedthermal', $data);
    }
    public function debt()
    {
        $data['title'] = 'Tunggakan';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $this->template->load('backend', 'backend/bill/debt', $data);
    }

    public function printdebt($no_services)
    {
        $data['title'] = 'Akumulasi Tagihan ' . $no_services;
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['customer'] = $this->customer_m->getNSCustomer($no_services)->row_array();
        $data['bill'] = $this->bill_m->getDebt($no_services)->num_rows();
        $data['bank'] = $this->setting_m->getBank()->result();

        $this->load->view('backend/bill/invoicedebt', $data);
    }
    public function billpaid()
    {
        $post = $this->input->post(null, TRUE);
        $invoice = $post['invoice'];
        $cekConfirm = $this->db->get_where('confirm_payment', ['invoice_id' => $post['invoice']])->row_array();
        // $customer = $this->db->get_where('customer', ['no_services' => $post['no_services']])->row_array();


        if ($cekConfirm > 0) {
            $this->bill_m->UpdateConfirmPayment($post);
        }
        $this->bill_m->payment($post);
        $this->income_m->addPaymentFast($post);
        $cekemail = $this->db->get('email')->row_array();
        if ($cekemail['send_payment'] == 1) {
            $this->_sendEmail('payment-success');
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success-payment', '<h3>Tagihan berhasil terbayarkan</h3> <a class="btn btn-success" target="blank" href="' . site_url('bill/printinvoice/' . $invoice) . '">Cetak A4</a>&nbsp; <a class="btn btn-success" target="blank" href="' . site_url('bill/printinvoicethermal/' . $invoice) . '">Cetak Thermal</a>');
        }
        echo "<script>window.location='" . site_url('bill') . "'; </script>";
    }

    // PAYMENT
    public function payment()
    {
        $post = $this->input->post(null, TRUE);
        $invoice = $this->input->post('invoice');
        $cekConfirm = $this->db->get_where('confirm_payment', ['invoice_id' => $post['invoice']])->row_array();
        if ($cekConfirm > 0) {
            $this->bill_m->UpdateConfirmPayment($post);
        }
        // $customer = $this->db->get_where('customer', ['no_services' => $post['no_services']])->row_array();


        $this->bill_m->payment($post);
        $this->income_m->addPayment($post);

        $cekemail = $this->db->get('email')->row_array();
        if ($cekemail['send_payment'] == 1) {
            $this->_sendEmail('payment-success');
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success-payment', '<h3>Tagihan berhasil terbayarkan</h3> <a class="btn btn-success" target="blank" href="' . site_url('bill/printinvoice/' . $invoice) . '">Cetak A4</a>&nbsp; <a class="btn btn-success" target="blank" href="' . site_url('bill/printinvoicethermal/' . $invoice) . '">Cetak Thermal</a>');
        }
        echo "<script>window.location='" . site_url('bill/detail/' . $invoice) . "'; </script>";
    }

    public function confirmPayment()
    {
        $config['upload_path']          = './assets/images/confirm';
        $config['allowed_types']        = 'gif|jpg|png|jpeg';
        $config['max_size']             = 2048; // 2 Mb
        $config['file_name']             = 'confirm-' . date('ymd') . '-' . substr(md5(rand()), 0, 10);
        $this->load->library('upload', $config);
        $post = $this->input->post(null, TRUE);
        if (@FILES['picture']['name'] != null) {
            if ($this->upload->do_upload('picture')) {
                $post['picture'] =  $this->upload->data('file_name');
                $this->bill_m->confirmPayment($post);
                $bot = $this->db->get('bot_telegram')->row_array();
                $tokens = $bot['token']; // token bot
                $owner = $bot['id_telegram_owner'];

                $sendmessage = [
                    'reply_markup' => json_encode([
                        'inline_keyboard' => [
                            [
                                ['text' => '✅ Konfirmasi', 'url' => base_url('confirmdetail/' . $post['no_invoice'])],

                            ]
                        ]
                    ]),
                    'resize_keyboard' => true,
                    'parse_mode' => 'html',
                    'text' => "<b>KONFIRMASI PEMBAYARAN</b>\nNama : $post[name]\nNo Layanan : $post[no_services]\nTagihan : $post[nominal]\nPeriode : $post[periode]\nTanggal Bayar : $post[date_payment]\nMetode Pembayaran : $post[metode_payment]\n",
                    'chat_id' => $owner
                ];

                file_get_contents("https://api.telegram.org/bot$tokens/sendMessage?" . http_build_query($sendmessage));
                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Konfirmasi pembayaran sudah terkirim, mohon tunggu untuk di verifikasi');
                }
                echo "<script>window.location='" . site_url('member/history') . "'; </script>";
            } else {
                $error = $this->upload->display_errors();
                $this->session->set_flashdata('error', $error);
                echo "<script>window.location='" . base_url('member/history') . "'; </script>";
            }
        }
    }

    public function confirm()
    {
        $data['title'] = 'Konfirmasi Pembayaran';
        $data['confirm'] = $this->bill_m->getConfirm()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $this->template->load('backend', 'backend/bill/confirm', $data);
    }

    public function confirmdetail($invoice)
    {
        $data['title'] = 'Detail Konfirmasi Pembayaran';
        $cekInvoice = $this->db->get_where('invoice', ['invoice' => $invoice])->row_array();
        if ($cekInvoice != null) {
            $data['invoice'] = $this->bill_m->getEditInvoice($invoice);
            $data['p_item'] = $this->package_m->getPItem()->result();
            $data['bill'] = $this->bill_m->getBill($invoice)->row_array();
            $data['company'] = $this->db->get('company')->row_array();
            $data['other'] = $this->db->get('other')->row_array();
            $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
            $this->template->load('backend', 'backend/bill/confirm-detail', $data);
        } else {
            $this->session->set_flashdata('error', 'Invoice tidak ditemukan');
            echo "<script>window.location='" . base_url('confirm') . "'; </script>";
        }
    }
    public function confirmUpdate()
    {
        $post = $this->input->post(null, TRUE);
        $invoice = $this->input->post('invoice');
        // $customer = $this->db->get_where('customer', ['no_services' => $post['no_services']])->row_array();


        $this->bill_m->payment($post);
        $this->bill_m->UpdateConfirm($post);
        $this->income_m->addPayment($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success-payment', '<h3>Pembayaran berhasil diverifikasi</h3> <a class="btn btn-success" target="blank" href="' . site_url('bill/printinvoice/' . $invoice) . '">Cetak A4</a>&nbsp; <a class="btn btn-success" target="blank" href="' . site_url('bill/printinvoicethermal/' . $invoice) . '">Cetak Thermal</a>');
        }
        echo "<script>window.location='" . site_url('confirm') . "'; </script>";
    }
    public function deleteconfirm()
    {
        $confirm_id = $this->input->post('confirm_id');
        $confirm = $this->db->get_where('confirm_payment', ['confirm_id' => $confirm_id])->row_array();
        $target_file = './assets/images/confirm/' . $confirm['picture'];
        $this->bill_m->deleteconfirm($confirm_id);
        unlink($target_file);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data konfirmasi berhasil dihapus');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    // SMS GATEWAY
    public function sendsms()
    {
        $sg = $this->db->get('sms_gateway')->row_array();
        $user = $sg['sms_user'];
        $password =  $sg['sms_password'];
        $mobile = $this->input->post('mobile');
        $message = $this->input->post('message');

        $url = 'https://soufasms.com/sms_gateway/?user=' . $user . '&pass=' . $password . 'no=' . $mobile . '&msg=' . $message . '';

        $header = array(
            'Accept: application/json',
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $result = curl_exec($ch);
        $hasil =  json_decode($result, true);
        if ($hasil['status'] == 200) {
            $this->session->set_flashdata('success-sendsms', $hasil['status_message']);
        } else {
            $this->session->set_flashdata('error-sendsms', $hasil['status_message']);
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    // KIRIM EMAIL
    private function _sendEmail($type)
    {
        $invoice_id =  $this->input->post('invoice');
        $to_email = $this->input->post('to_email');
        $no_services = $this->input->post('no_services');
        $email_customer = $this->input->post('email_customer');
        $name = $this->input->post('name');
        $agen = $this->input->post('agen');
        $email_agen = $this->input->post('email_agen');
        $date_payment = $this->input->post('date_payment');
        $periode = $this->input->post('periode');
        $total = $this->input->post('nominal');
        $email = $this->db->get('email')->row_array();
        $company = $this->db->get('company')->row_array();
        $config = [
            'protocol'  => $email['protocol'],
            'smtp_host' => $email['host'],
            'smtp_user' => $email['email'], // isi Alamat email
            'smtp_pass' => $email['password'], // Isi Password email
            'smtp_port' => $email['port'],
            'mailtype'  => 'html',
            'charset'   => 'utf-8',
            'newline'   => "\r\n"
        ];
        $this->email->initialize($config);
        $this->load->library('email', $config);
        $this->email->from($email['email'], $email['name']); // isi Alamat email dan nama pengirim
        if ($type == 'verify-payment') {
            $this->email->to($to_email);
            $this->email->subject('Verifikasi Pembayaran');
            $this->email->message('Yth. Pelanggan <b>' . $company['company_name'] . '</b> <br> berikut kami sampaikan status transaksi <b>SUKSES</b> <br>
                      No invoice : <b>' . $invoice_id . ' </b> <br>
                      No layanan : <b>' . $no_services . '</b> <br>
                      Nama Pelanggan : ' . $name . ' <br>
                      Periode : <b>' . $periode . '</b> <br>
                      Total Tagihan : <b>' . $total . '</b> <br>
                      Terimakasih telah menggunakan layanan <b>' . $company['company_name'] . '</b> <br><br>
                      Salam,');
        } elseif ($type == 'payment-success') {
            $this->email->to([$to_email, $email_agen, $email_customer]);
            $this->email->subject('Informasi Pembayaran');
            $this->email->message('<b>' . $company['company_name'] . '</b> <br> berikut kami sampaikan status transaksi <b>SUKSES</b> <br>
                      No invoice : <b>' . $invoice_id . ' </b> <br>
                      No layanan : <b>' . $no_services . '</b> <br>
                      Nama Pelanggan : ' . $name . ' <br>
                      Periode : <b>' . $periode . '</b> <br>
                      Total Tagihan : <b>' . indo_currency($total) . '</b> <br>
                      Diterima Oleh : <b>' . $agen . ' | ' . $email_agen . '</b> <br>
                      Tanggal : <b>' . $date_payment . '</b> <br>
                      <br>
                      <a href="' . base_url() . 'bill/printinvoice/' . $invoice_id . '">Cetak A4</a>
                      <br>
                      <a href="' . base_url() . 'bill/printinvoicethermal/' . $invoice_id . '">Cetak Thermal</a>
                      <br><br>
                      <b>' . $company['company_name'] . '</b> <br><br>
                      Salam,');
        }
        if ($this->email->send()) {
            return true;
        } else {
            echo $this->email->print_debugger();
            die;
        }
    }
    // SERVER SIDE
    public function getDataInvoice()
    {
        $result = $this->bill_m->getDataInv();
        $data = [];
        $no = $_POST['start'];
        foreach ($result as $result) {
            $row = array();
            $row[] = ++$no;
            $row[] = '<input type=' . 'checkbox' . ' class=' . 'check-item' . ' id="ceklis" name=' . 'invoice[]' . ' value=' . $result->invoice . '>';
            $row[] =  $result->name;
            if ($result->status == 'SUDAH BAYAR') {
                $row[] =
                    '<a href="#" id="printinvoice" data-printinvoice="' . $result->invoice . '"   title="Cetak Invoice"  style="color:green" data-toggle="modal" data-target="#PrintModalPaid"><i class="fa fa-print"></i></a>
                  ';
            } else {
                $row[] =
                    '<a href="#" id="printinvoice" data-printinvoice="' . $result->invoice . '"  title="Cetak Invoice" style="color:red" data-toggle="modal" data-target="#PrintModalUnpaid"><i class="fa fa-print"></i></a>
                       ';
            }
            $row[] =  $result->invoice;
            $row[] =  $result->no_services;
            $row[] = $result->no_wa;
            $row[] = indo_month($result->month) . ' ' . $result->year;
            $other = $this->db->get('other')->row_array();
            if ($other['code_unique'] == 1) {
                $codeunique =  $result->code_unique;
            } else {
                $codeunique = 0;
            }
            if ($result->amount != 0) {
                $row[] = indo_currency($result->amount + $codeunique);
            }
            if ($result->amount == 0) {
                $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`invoice_id` =  $result->invoice";
                $querying = $this->db->query($query)->result();
                $subTotal = 0;
                foreach ($querying as  $dataa)
                    $subTotal += (int) $dataa->total;
                if ($subTotal != 0) {
                    $ppn = $subTotal * ($result->i_ppn / 100);
                    $row[] = indo_currency($subTotal + $ppn + $codeunique);
                } else {
                    $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`d_month` =  $result->month and
                                       `invoice_detail`.`d_year` =  $result->year and
                                       `invoice_detail`.`d_no_services` =  $result->no_services";
                    $queryTot = $this->db->query($query)->result();
                    $subTotaldetail = 0;
                    foreach ($queryTot as  $dataa)
                        $subTotaldetail += (int) $dataa->total;
                    $ppn = $subTotaldetail * ($result->i_ppn / 100);
                    $row[] = indo_currency($subTotaldetail + $ppn + $codeunique);
                }
            }
            if ($result->amount != 0) {
                $nominal = $result->amount + $codeunique;
                $nominalbayar = $result->amount;
            } else {
                $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`invoice_id` =  $result->invoice";
                $querying = $this->db->query($query)->result();
                $subTotal = 0;
                foreach ($querying as  $dataa)
                    $subTotal += (int) $dataa->total;
                if ($subTotal != 0) {
                    $ppn = $subTotal * ($result->i_ppn / 100);
                    $nominal = $subTotal + $ppn  + $codeunique;
                    $nominalbayar = $subTotal + $ppn;
                } else {
                    $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`d_month` =  $result->month and
                                       `invoice_detail`.`d_year` =  $result->year and
                                       `invoice_detail`.`d_no_services` =  $result->no_services";
                    $queryTot = $this->db->query($query)->result();
                    $subTotaldetail = 0;
                    foreach ($queryTot as  $dataa)
                        $subTotaldetail += (int) $dataa->total;
                    $ppn = $subTotaldetail * ($result->i_ppn / 100);
                    $nominal = $subTotaldetail + $ppn + $codeunique;
                    $nominalbayar = $subTotaldetail + $ppn;
                }
            }

            $company = $this->db->get('company')->row_array();

            if ($result->due_date != 0) {
                $due_date = $result->due_date;
            } else {
                $due_date = $company['due_date'];
            }
            $row[] = $result->status;
            $row[] = $result->address;
            $search  = array('{name}', '{noservices}', '{month}', '{year}', '{period}', '{duedate}', '{nominal}', '{companyname}',  '{slogan}', '{link}', '{e}');
            $replace = array($result->name, $result->no_services, $result->month, $result->year, indo_month($result->month) . ' ' . $result->year, $due_date, indo_currency($nominal), $company['company_name'], $company['sub_name'], base_url(), '%0A');
            $subject = $other['say_wa'];
            $subjectthanks = $other['thanks_wa'];
            $message = str_replace($search, $replace, $subject);
            $messagethanks = str_replace($search, $replace, $subjectthanks);
            $linkWA = "https://api.whatsapp.com/send?phone=";
            if ($result->status == 'SUDAH BAYAR') {
                $row[] = '<a href="' . site_url('bill/detail/' . $result->invoice) . '" ><i class="fas fa-eye" style="font-size:20px; color:gray"></i></a> 
                <a href="#" id="hapusmodal" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . $result->month . '" data-name="' . $result->name . '" data-invoice="' . $result->invoice . '" data-periode="' . indo_month($result->month) . ' ' . $result->year . '"  data-toggle="modal" data-target="#DeleteModal" ><i class="fas fa-trash" style="font-size:20px; color:red"></i></a>
                <a href="' . $linkWA . indo_tlp($result->no_wa) . '&text=' . $messagethanks . '" target="blank"><i class="fab fa-whatsapp" style="font-size:20px; color:green"></i></a> ';
            } else {
                $row[] = '<a href="#" id="bayar" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . indo_month($result->month) . '" data-invoice="' . $result->invoice . '" data-name="' . $result->name . '"  data-email_customer="' . $result->email . '"  data-periode="' . indo_month($result->month) . ' ' . $result->year . '" data-nominal="' . $nominalbayar . '" data-toggle="modal" data-target="#ModalBayar"><i class="fas fa-credit-card"></i></a> <a href="' . site_url('bill/detail/' . $result->invoice) . '" ><i class="fas fa-eye" style="font-size:20px; color:gray"></i></a> 
                <a href="' . $linkWA . indo_tlp($result->no_wa) . '&text=' . $message   . '" target="blank"><i class="fab fa-whatsapp" style="font-size:20px; color:green"></i></a>
                <a href="#" id="hapusmodal" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . $result->month . '" data-name="' . $result->name . '" data-invoice="' . $result->invoice . '" data-periode="' . indo_month($result->month) . ' ' . $result->year . '"  data-toggle="modal" data-target="#DeleteModal" ><i class="fas fa-trash" style="font-size:20px; color:red"></i></a>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->bill_m->count_all_data(),
            "recordsFiltered" => $this->bill_m->count_filtered_data(),
            "data" => $data,
        );

        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }
    public function getUnpaidInvoice()
    {
        $result = $this->bill_m->getUnpaidInv();
        $data = [];
        $no = $_POST['start'];
        foreach ($result as $result) {
            $row = array();
            $row[] = ++$no;
            $row[] = '<input type=' . 'checkbox' . ' class=' . 'check-item' . ' id="ceklis" name=' . 'invoice[]' . ' value=' . $result->invoice . '>';
            $row[] =  $result->name;
            if ($result->status == 'SUDAH BAYAR') {
                $row[] =
                    '<a href="#" id="printinvoice" data-printinvoice="' . $result->invoice . '"   title="Cetak Invoice"  style="color:green" data-toggle="modal" data-target="#PrintModalPaid"><i class="fa fa-print"></i></a>
                  ';
            } else {
                $row[] =
                    '<a href="#" id="printinvoice" data-printinvoice="' . $result->invoice . '"  title="Cetak Invoice" style="color:red" data-toggle="modal" data-target="#PrintModalUnpaid"><i class="fa fa-print"></i></a>
                       ';
            }
            $row[] =  $result->invoice;
            $row[] =  $result->no_services;
            $row[] = $result->no_wa;
            $row[] = indo_month($result->month) . ' ' . $result->year;
            $other = $this->db->get('other')->row_array();
            if ($other['code_unique'] == 1) {
                $codeunique =  $result->code_unique;
            } else {
                $codeunique = 0;
            }
            if ($result->amount != 0) {
                $row[] = indo_currency($result->amount + $codeunique);
            }
            if ($result->amount == 0) {
                $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`invoice_id` =  $result->invoice";
                $querying = $this->db->query($query)->result();
                $subTotal = 0;
                foreach ($querying as  $dataa)
                    $subTotal += (int) $dataa->total;
                if ($subTotal != 0) {
                    $ppn = $subTotal * ($result->i_ppn / 100);
                    $row[] = indo_currency($subTotal + $ppn + $codeunique);
                } else {
                    $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`d_month` =  $result->month and
                                       `invoice_detail`.`d_year` =  $result->year and
                                       `invoice_detail`.`d_no_services` =  $result->no_services";
                    $queryTot = $this->db->query($query)->result();
                    $subTotaldetail = 0;
                    foreach ($queryTot as  $dataa)
                        $subTotaldetail += (int) $dataa->total;
                    $ppn = $subTotaldetail * ($result->i_ppn / 100);
                    $row[] = indo_currency($subTotaldetail + $ppn + $codeunique);
                }
            }
            if ($result->amount != 0) {
                $nominal = $result->amount + $codeunique;
                $nominalbayar = $result->amount;
            } else {
                $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`invoice_id` =  $result->invoice";
                $querying = $this->db->query($query)->result();
                $subTotal = 0;
                foreach ($querying as  $dataa)
                    $subTotal += (int) $dataa->total;
                if ($subTotal != 0) {
                    $ppn = $subTotal * ($result->i_ppn / 100);
                    $nominal = $subTotal + $ppn  + $codeunique;
                    $nominalbayar = $subTotal + $ppn;
                } else {
                    $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`d_month` =  $result->month and
                                       `invoice_detail`.`d_year` =  $result->year and
                                       `invoice_detail`.`d_no_services` =  $result->no_services";
                    $queryTot = $this->db->query($query)->result();
                    $subTotaldetail = 0;
                    foreach ($queryTot as  $dataa)
                        $subTotaldetail += (int) $dataa->total;
                    $ppn = $subTotaldetail * ($result->i_ppn / 100);
                    $nominal = $subTotaldetail + $ppn + $codeunique;
                    $nominalbayar = $subTotaldetail + $ppn;
                }
            }
            $company = $this->db->get('company')->row_array();

            if ($result->due_date != 0) {
                $due_date = $result->due_date;
            } else {
                $due_date = $company['due_date'];
            }
            $row[] = $result->status;
            $search  = array('{name}', '{noservices}', '{month}', '{year}', '{period}', '{duedate}', '{nominal}', '{companyname}',  '{slogan}', '{link}', '{e}');
            $replace = array($result->name, $result->no_services, $result->month, $result->year, indo_month($result->month) . ' ' . $result->year, $due_date, indo_currency($nominal), $company['company_name'], $company['sub_name'], base_url(), '%0A');
            $subject = $other['say_wa'];
            $subjectthanks = $other['thanks_wa'];
            $message = str_replace($search, $replace, $subject);
            $messagethanks = str_replace($search, $replace, $subjectthanks);
            $linkWA = "https://api.whatsapp.com/send?phone=";
            if ($result->status == 'SUDAH BAYAR') {
                $row[] = '<a href="' . site_url('bill/detail/' . $result->invoice) . '" ><i class="fas fa-eye" style="font-size:20px; color:gray"></i></a> 
                <a href="#" id="hapusmodal" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . $result->month . '" data-name="' . $result->name . '" data-invoice="' . $result->invoice . '" data-periode="' . indo_month($result->month) . ' ' . $result->year . '"  data-toggle="modal" data-target="#DeleteModal" ><i class="fas fa-trash" style="font-size:20px; color:red"></i></a>
                <a href="' . $linkWA . indo_tlp($result->no_wa) . '&text=' . $messagethanks . '" target="blank"><i class="fab fa-whatsapp" style="font-size:20px; color:green"></i></a> ';
            } else {
                $row[] = '<a href="#" id="bayar" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . indo_month($result->month) . '" data-invoice="' . $result->invoice . '" data-name="' . $result->name . '"  data-email_customer="' . $result->email . '"  data-periode="' . indo_month($result->month) . ' ' . $result->year . '" data-nominal="' . $nominalbayar . '" data-toggle="modal" data-target="#ModalBayar"><i class="fas fa-credit-card"></i></a> <a href="' . site_url('bill/detail/' . $result->invoice) . '" ><i class="fas fa-eye" style="font-size:20px; color:gray"></i></a> 
                <a href="' . $linkWA . indo_tlp($result->no_wa) . '&text=' . $message   . '" target="blank"><i class="fab fa-whatsapp" style="font-size:20px; color:green"></i></a>
                <a href="#" id="hapusmodal" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . $result->month . '" data-name="' . $result->name . '" data-invoice="' . $result->invoice . '" data-periode="' . indo_month($result->month) . ' ' . $result->year . '"  data-toggle="modal" data-target="#DeleteModal" ><i class="fas fa-trash" style="font-size:20px; color:red"></i></a>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->db->get_where('invoice', ['status' => 'BELUM BAYAR'])->num_rows(),
            "recordsFiltered" => $this->db->get_where('invoice', ['status' => 'BELUM BAYAR'])->num_rows(),
            "data" => $data,
        );

        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }
    public function getPaidInvoice()
    {
        $result = $this->bill_m->getPaidInv();
        $data = [];
        $no = $_POST['start'];
        foreach ($result as $result) {
            $row = array();
            $row[] = ++$no;
            $row[] = '<input type=' . 'checkbox' . ' class=' . 'check-item' . ' id="ceklis" name=' . 'invoice[]' . ' value=' . $result->invoice . '>';
            $row[] =  $result->name;
            if ($result->status == 'SUDAH BAYAR') {
                $row[] =
                    '<a href="#" id="printinvoice" data-printinvoice="' . $result->invoice . '"   title="Cetak Invoice"  style="color:green" data-toggle="modal" data-target="#PrintModalPaid"><i class="fa fa-print"></i></a>
                  ';
            } else {
                $row[] =
                    '<a href="#" id="printinvoice" data-printinvoice="' . $result->invoice . '"  title="Cetak Invoice" style="color:red" data-toggle="modal" data-target="#PrintModalUnpaid"><i class="fa fa-print"></i></a>
                       ';
            }
            $row[] =  $result->invoice;
            $row[] =  $result->no_services;
            $row[] = $result->no_wa;
            $row[] = indo_month($result->month) . ' ' . $result->year;
            $other = $this->db->get('other')->row_array();
            if ($other['code_unique'] == 1) {
                $codeunique =  $result->code_unique;
            } else {
                $codeunique = 0;
            }
            if ($result->amount != 0) {
                $row[] = indo_currency($result->amount + $codeunique);
            }
            if ($result->amount == 0) {
                $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`invoice_id` =  $result->invoice";
                $querying = $this->db->query($query)->result();
                $subTotal = 0;
                foreach ($querying as  $dataa)
                    $subTotal += (int) $dataa->total;
                if ($subTotal != 0) {
                    $ppn = $subTotal * ($result->i_ppn / 100);
                    $row[] = indo_currency($subTotal + $ppn + $codeunique);
                } else {
                    $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`d_month` =  $result->month and
                                       `invoice_detail`.`d_year` =  $result->year and
                                       `invoice_detail`.`d_no_services` =  $result->no_services";
                    $queryTot = $this->db->query($query)->result();
                    $subTotaldetail = 0;
                    foreach ($queryTot as  $dataa)
                        $subTotaldetail += (int) $dataa->total;
                    $ppn = $subTotaldetail * ($result->i_ppn / 100);
                    $row[] = indo_currency($subTotaldetail + $ppn + $codeunique);
                }
            }
            if ($result->amount != 0) {
                $nominal = $result->amount + $codeunique;
                $nominalbayar = $result->amount;
            } else {
                $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`invoice_id` =  $result->invoice";
                $querying = $this->db->query($query)->result();
                $subTotal = 0;
                foreach ($querying as  $dataa)
                    $subTotal += (int) $dataa->total;
                if ($subTotal != 0) {
                    $ppn = $subTotal * ($result->i_ppn / 100);
                    $nominal = $subTotal + $ppn  + $codeunique;
                    $nominalbayar = $subTotal + $ppn;
                } else {
                    $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`d_month` =  $result->month and
                                       `invoice_detail`.`d_year` =  $result->year and
                                       `invoice_detail`.`d_no_services` =  $result->no_services";
                    $queryTot = $this->db->query($query)->result();
                    $subTotaldetail = 0;
                    foreach ($queryTot as  $dataa)
                        $subTotaldetail += (int) $dataa->total;
                    $ppn = $subTotaldetail * ($result->i_ppn / 100);
                    $nominal = $subTotaldetail + $ppn + $codeunique;
                    $nominalbayar = $subTotaldetail + $ppn;
                }
            }
            $company = $this->db->get('company')->row_array();

            if ($result->due_date != 0) {
                $due_date = $result->due_date;
            } else {
                $due_date = $company['due_date'];
            }
            $row[] = $result->status;
            $search  = array('{name}', '{noservices}', '{month}', '{year}', '{period}', '{duedate}', '{nominal}', '{companyname}',  '{slogan}', '{link}', '{e}');
            $replace = array($result->name, $result->no_services, $result->month, $result->year, indo_month($result->month) . ' ' . $result->year, $due_date, indo_currency($nominal), $company['company_name'], $company['sub_name'], base_url(), '%0A');
            $subject = $other['say_wa'];
            $subjectthanks = $other['thanks_wa'];
            $message = str_replace($search, $replace, $subject);
            $messagethanks = str_replace($search, $replace, $subjectthanks);
            $linkWA = "https://api.whatsapp.com/send?phone=";
            if ($result->status == 'SUDAH BAYAR') {
                $row[] = '<a href="' . site_url('bill/detail/' . $result->invoice) . '" ><i class="fas fa-eye" style="font-size:20px; color:gray"></i></a> 
                <a href="#" id="hapusmodal" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . $result->month . '" data-name="' . $result->name . '" data-invoice="' . $result->invoice . '" data-periode="' . indo_month($result->month) . ' ' . $result->year . '"  data-toggle="modal" data-target="#DeleteModal" ><i class="fas fa-trash" style="font-size:20px; color:red"></i></a>
                <a href="' . $linkWA . indo_tlp($result->no_wa) . '&text=' . $messagethanks . '" target="blank"><i class="fab fa-whatsapp" style="font-size:20px; color:green"></i></a> ';
            } else {
                $row[] = '<a href="#" id="bayar" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . indo_month($result->month) . '" data-invoice="' . $result->invoice . '" data-name="' . $result->name . '"  data-email_customer="' . $result->email . '"  data-periode="' . indo_month($result->month) . ' ' . $result->year . '" data-nominal="' . $nominalbayar . '" data-toggle="modal" data-target="#ModalBayar"><i class="fas fa-credit-card"></i></a> <a href="' . site_url('bill/detail/' . $result->invoice) . '" ><i class="fas fa-eye" style="font-size:20px; color:gray"></i></a> 
                <a href="' . $linkWA . indo_tlp($result->no_wa) . '&text=' . $message   . '" target="blank"><i class="fab fa-whatsapp" style="font-size:20px; color:green"></i></a>
                <a href="#" id="hapusmodal" data-no_servicess="' . $result->no_services . '" data-invoice_id="' . $result->invoice_id . '" data-yearr="' . $result->year . '" data-month="' . $result->month . '" data-name="' . $result->name . '" data-invoice="' . $result->invoice . '" data-periode="' . indo_month($result->month) . ' ' . $result->year . '"  data-toggle="modal" data-target="#DeleteModal" ><i class="fas fa-trash" style="font-size:20px; color:red"></i></a>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->db->get_where('invoice', ['status' => 'SUDAH BAYAR'])->num_rows(),
            "recordsFiltered" => $this->db->get_where('invoice', ['status' => 'SUDAH BAYAR'])->num_rows(),
            "data" => $data,
        );

        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }

    public function payselected()
    {
        $invoice = $_POST['invoice'];
        if ($invoice == null) {
            $this->session->set_flashdata('error', 'tagihan belum dipilih');
        } else {
            $datainvoice = $this->bill_m->getInvoiceSelected($invoice)->result();
            $dataIncome = [];
            foreach ($datainvoice as $key => $row) {
                if ($row->amount == 0) {
                    $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`invoice_id` =  $row->invoice";
                    $querying = $this->db->query($query)->result();
                    $subTotal = 0;
                    foreach ($querying as  $dataa)
                        $subTotal += (int) $dataa->total;
                    if ($subTotal != 0) {
                        $ppn = $subTotal * ($row->i_ppn / 100);
                        $nominal = $subTotal + $ppn;
                    } else {
                        $query = "SELECT * FROM `invoice_detail` WHERE `invoice_detail`.`d_month` =  $row->month and
                                           `invoice_detail`.`d_year` =  $row->year and
                                           `invoice_detail`.`d_no_services` =  $row->no_services";
                        $queryTot = $this->db->query($query)->result();
                        $subTotaldetail = 0;
                        foreach ($queryTot as  $dataa)
                            $subTotaldetail += (int) $dataa->total;
                        $ppn = $subTotaldetail * ($row->i_ppn / 100);
                        $nominal = $subTotaldetail + $ppn;
                    }
                } else {
                    $nominal = $row->amount;
                }
                array_push(
                    $dataIncome,
                    array(
                        'nominal' => $nominal,
                        'category' => 1,
                        'invoice_id' => $row->invoice,
                        'no_services' => $row->no_services,
                        'date_payment' => date('Y-m-d'),
                        'remark' => 'Pembayaran Tagihan no layanan' . ' ' . $row->no_services . ' ' . 'a/n' . ' ' . $row->name . ' ' . 'Periode' . ' ' . indo_month($row->month) . ' ' . $row->year,
                        'create_by' => $this->session->userdata('id')
                    )
                );
            }
            $this->income_m->payselected($dataIncome);
            $this->bill_m->payselected($invoice);
            if ($this->db->affected_rows() > 0) {

                $this->session->set_flashdata('success', 'Tagihan berhasil dibayarkan');
            }
        }

        redirect($_SERVER['HTTP_REFERER']);
    }

    public function delselected()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['del_bill'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('dashboard');
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $invoice =  $_POST['invoice'];
        if ($invoice == null) {
            $this->session->set_flashdata('error', 'Tagihan belum dipilih');
        } else {
            $cekConfir = $this->bill_m->confirmselected($invoice)->result();
            $cekIncome = $this->income_m->incomeselected($invoice)->result();
            // var_dump($cekConfir);
            // die;
            if (count($cekConfir) > 0) {
                $this->session->set_flashdata('error', 'Tagihan tidak bisa dihapus dikarenakan masih ada di konfirmasi pembayaran');
            } elseif (count($cekIncome) > 0) {
                $this->session->set_flashdata('error', 'Tagihan tidak bisa dihapus dikarenakan masih ada di data pendapadatan');
                # code...
            } else {
                $datainvoice = $this->bill_m->getInvoiceSelected($invoice)->result();
                foreach ($datainvoice as $key => $row) {
                    $month = $row->month;
                    $year = $row->year;
                    $invoiceqr = $row->invoice;
                    $no_services = $row->no_services;
                    $this->bill_m->deletedetailselected($month, $year, $no_services);
                    $target_file = './assets/images/qrcode/' . $invoiceqr . '.png';
                    unlink($target_file);
                }
                $this->bill_m->deleteselected($invoice);
                // $this->bill_m->deleteDetailInvoice($invoice);
                // $this->bill_m->deleteDetailBill($post);

                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Data Tagihan berhasil dihapus');
                }
            }
        }

        redirect($_SERVER['HTTP_REFERER']);
    }
    public function printinvoicedotmatrix($invoice, $a = null, $b = null, $c = null, $d = null)
    {
        // echo $invoice . '/' . $a . '/' . $b . '/' . $c .
        //     var_dump($invoice, $a, $b, $c);
        // die;
        if ($a == null) {
            $invoice =  $invoice;
        } elseif ($b == null) {
            $invoice = '' . $invoice . '/' . $a;
        } elseif ($c == null) {
            $invoice = '' . $invoice . '/' . $a . '/' . $b;
        } elseif ($d == null) {
            $invoice = '' . $invoice . '/' . $a . '/' . $b . '/' . $c;
        } else {
            $invoice = '' . $invoice . '/' . $a . '/' . $b . '/' . $c . '/' . $d;
        }

        // var_dump($invoice);
        // die;
        $data['title'] = 'Invoice Dot Matrix';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['invoice'] = $this->bill_m->getBill($invoice);
        $data['invoice_detail'] = $this->bill_m->getDetailBill($invoice);
        $data['bill'] = $this->bill_m->getBill($invoice)->row_array();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();

        $data['other'] = $this->db->get('other')->row_array();
        $this->load->library('ciqrcode'); //pemanggilan library QR CODE
        $config['cacheable']    = true; //boolean, the default is true
        $config['cachedir']     = './assets/'; //string, the default is application/cache/
        $config['errorlog']     = './assets/'; //string, the default is application/logs/
        $config['imagedir']     = './assets/images/qrcode/'; //direktori penyimpanan qr code
        $config['quality']      = true; //boolean, the default is true
        $config['size']         = '1024'; //interger, the default is 1024
        $config['black']        = array(224, 255, 255); // array, default is array(255,255,255)
        $config['white']        = array(70, 130, 180); // array, default is array(0,0,0)
        $inv = $this->db->get_where('invoice', ['invoice' => $invoice])->row_array();
        $this->ciqrcode->initialize($config);
        $image_name = $invoice . '.png'; //buat name dari qr code
        $params['data'] = $invoice . '-' . $inv['no_services']; //data yang akan di jadikan QR CODE
        $params['level'] = 'H'; //H=High
        $params['size'] = 10;
        $params['savename'] = FCPATH . $config['imagedir'] . $image_name; //simpan image QR CODE ke folder assets/images/
        $this->ciqrcode->generate($params); // fungsi untuk generate QR CODE
        $this->load->view('backend/bill/invoicedotmatrix', $data);
    }
    public function printinvoicesmall($invoice, $a = null, $b = null, $c = null, $d = null)
    {

        if ($a == null) {
            $invoice =  $invoice;
        } elseif ($b == null) {
            $invoice = '' . $invoice . '/' . $a;
        } elseif ($c == null) {
            $invoice = '' . $invoice . '/' . $a . '/' . $b;
        } elseif ($d == null) {
            $invoice = '' . $invoice . '/' . $a . '/' . $b . '/' . $c;
        } else {
            $invoice = '' . $invoice . '/' . $a . '/' . $b . '/' . $c . '/' . $d;
        }
        $oldinvoicedetail = $this->db->get_where('invoice_detail', ['invoice_id' => $invoice])->row_array();
        $oldinvoice = $this->db->get_where('invoice', ['invoice' => $invoice])->row_array();
        if ($oldinvoicedetail['d_month'] == 0) {
            $update = [
                'd_month' => $oldinvoice['month'],
                'd_year' => $oldinvoice['year'],
                'd_no_services' => $oldinvoice['no_services'],
            ];
            $this->db->where('invoice_id', $invoice);
            $this->db->update('invoice_detail', $update);
        }
        // var_dump($invoice);
        // die;
        $data['title'] = 'Invoice Dot Matrix';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['invoice'] = $this->bill_m->getBill($invoice);
        $data['invoice_detail'] = $this->bill_m->getDetailBill($invoice);
        $data['bill'] = $this->bill_m->getBill($invoice)->row_array();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['p_item'] = $this->package_m->getPItem()->result();

        $data['other'] = $this->db->get('other')->row_array();
        $this->load->view('backend/bill/invoicesmall', $data);
    }
    public function printinvoicedotmatrixselected()
    {
        $invoice = $_POST['invoice'];
        if ($invoice == null) {
            $this->session->set_flashdata('error', 'Tagihan belum dipilih');
            redirect($_SERVER['HTTP_REFERER']);
        } else {
            $data['title'] = 'Invoice Dot Metrix Selected';
            $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
            $data['company'] = $this->db->get('company')->row_array();
            $data['invoice'] = $this->bill_m->getBill($invoice)->result();
            $data['invoice_detail'] = $this->bill_m->getBill($invoice)->result();
            $data['bill'] = $this->bill_m->getInvoiceSelected($invoice)->result();
            $data['other'] = $this->db->get('other')->row_array();
            $data['bank'] = $this->setting_m->getBank()->result();
            $data['p_item'] = $this->package_m->getPItem()->result();

            $this->load->view('backend/bill/invoicedotmatrixselected', $data);
        }
    }

    public function searchunpaid()
    {
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Belum Bayar';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['bill'] = $this->bill_m->getSearchUnpaid($post)->result();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/bill/search', $data);
    }
    public function searchpaid()
    {
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Sudah Bayar';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['bill'] = $this->bill_m->getSearchPaid($post)->result();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/bill/search', $data);
    }
}
