<?php defined('BASEPATH') or exit('No direct script access allowed');

class customer extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        is_logged_in();
        $this->load->model(['customer_m', 'services_m', 'bill_m']);
    }
    public function index()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['show_customer'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Customer';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['coverage'] = $this->db->get('coverage')->result();
        $this->template->load('backend', 'backend/customer/data', $data);
    }
    public function active()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['show_customer'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Aktif';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomerActive()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['coverage'] = $this->db->get('coverage')->result();
        $this->template->load('backend', 'backend/customer/data', $data);
    }
    public function nonactive()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['show_customer'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Non-Aktif';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomerNonactive()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['coverage'] = $this->db->get('coverage')->result();
        $this->template->load('backend', 'backend/customer/data', $data);
    }
    public function filterby()
    {
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Customer Filter';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getfilterby($post)->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/customer/filterby', $data);
    }
    public function wait()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['show_customer'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Waiting';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomerWait()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['coverage'] = $this->db->get('coverage')->result();
        $this->template->load('backend', 'backend/customer/data', $data);
    }
    public function add()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['add_customer'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('no_ktp', 'No KTP', 'trim');
        $this->form_validation->set_rules('no_services', 'No Service', 'required|trim|is_unique[customer.no_services]');
        $this->form_validation->set_rules('no_wa', 'No Whatsapp', 'required|trim|is_unique[customer.no_wa]');
        $this->form_validation->set_rules('email', 'Email', 'required|trim|valid_email|is_unique[customer.email]');
        $this->form_validation->set_rules('password1', 'Password', 'required|trim|min_length[3]|matches[password2]', [
            'matches' => 'Password tidak sama !',
            'min_length' => 'Password terlalu pendek !'
        ]);
        $this->form_validation->set_rules('password2', 'Password', 'required|trim|matches[password1]');
        $this->form_validation->set_message('required', '%s Tidak boleh kosong, Silahkan isi');
        $this->form_validation->set_message('is_unique', '%s Sudah dipakai, Silahkan ganti');
        if ($this->form_validation->run() == false) {
            $data['title'] = 'Add Customer';
            $data['company'] = $this->db->get('company')->row_array();
            $data['coverage'] = $this->db->get('coverage')->result();
            $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
            $this->template->load('backend', 'backend/customer/add_customer', $data);
        } else {
            $post = $this->input->post(null, TRUE);
            $cekCs = $this->db->get_where('user', ['email' => $post['email']])->num_rows();
            if ($cekCs > 0) {
                $this->customer_m->add($post);
                $item = $this->db->get_where('package_item', ['p_item_id' => $post['paket']])->row_array();
                $datapaket = [
                    'item_id' => $item['p_item_id'],
                    'category_id' => $item['category_id'],
                    'no_services' => $post['no_services'],
                    'qty' => 1,
                    'disc' => 0,
                    'price' => $item['price'],
                    'total' => $item['price'],
                    'services_create' => time(),
                ];
                $this->db->insert('services', $datapaket);
                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Data Pelanggan berhasil disimpan, silahkan cek kembali paket pelanggan');
                }
                echo "<script>window.location='" . site_url('services/detail/' . $this->input->post('no_services')) . "'; </script>";
            } else {
                $email = $this->input->post('email', true);
                $data = [
                    'name' => htmlspecialchars($this->input->post('name', true)),
                    'email' => htmlspecialchars($email),
                    'image' => 'default.jpg',
                    'password' => password_hash($this->input->post('password1'), PASSWORD_DEFAULT),
                    'role_id' => 2,
                    'phone' => $this->input->post('no_wa', true),
                    'address' => htmlspecialchars($this->input->post('address', true)),
                    'is_active' => 1,
                    'date_created' => time()
                ];
                $this->db->insert('user', $data);
                $this->customer_m->add($post);
                $item = $this->db->get_where('package_item', ['p_item_id' => $post['paket']])->row_array();
                $datapaket = [
                    'item_id' => $item['p_item_id'],
                    'category_id' => $item['category_id'],
                    'no_services' => $post['no_services'],
                    'qty' => 1,
                    'disc' => 0,
                    'price' => $item['price'],
                    'total' => $item['price'],
                    'services_create' => time(),
                ];
                $this->db->insert('services', $datapaket);
                $this->session->set_flashdata('success', 'Data Pelanggan berhasil disimpan, silahkan cek kembali paket pelanggan');
                echo "<script>window.location='" . site_url('services/detail/' . $this->input->post('no_services')) . "'; </script>";
            }
        }
    }

    public function edit($customer_id)
    {
        is_logged_in();
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['edit_customer'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('no_ktp', 'No KTP', 'trim');
        $this->form_validation->set_rules('no_wa', 'No Whatsapp', 'required|trim|callback_no_wa_check');
        $this->form_validation->set_rules('email', 'Email', 'required|trim|valid_email|callback_email_check');
        $this->form_validation->set_message('required', '%s Tidak boleh kosong, Silahkan isi');
        $this->form_validation->set_message('is_unique', '%s Sudah dipakai, Silahkan ganti');
        if ($this->form_validation->run() == false) {
            $query  = $this->customer_m->getCustomer($customer_id);
            if ($query->num_rows() > 0) {
                $data['customer'] = $query->row();
                $data['title'] = 'Edit Customer';
                $data['company'] = $this->db->get('company')->row_array();
                $data['coverage'] = $this->db->get('coverage')->result();
                $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
                $this->template->load('backend', 'backend/customer/edit_customer', $data);
            } else {
                echo "<script> alert ('Data tidak ditemukan');";
                echo "window.location='" . site_url('customer') . "'; </script>";
            }
        } else {
            $post = $this->input->post(null, TRUE);
            $this->customer_m->edit($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data Pelanggan berhasil diperbaharui');
            }
            echo "<script>window.location='" . site_url('customer') . "'; </script>";
        }
    }

    public function detail($no_services)
    {
    }

    function email_check()
    {
        $post = $this->input->post(null, TRUE);
        $query = $this->db->query("SELECT * FROM customer WHERE email = '$post[email]' AND customer_id != '$post[customer_id]'");
        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('email_check', '%s Ini sudah dipakai, Silahkan ganti !');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    function no_wa_check()
    {
        $post = $this->input->post(null, TRUE);
        $query = $this->db->query("SELECT * FROM customer WHERE no_wa = '$post[no_wa]' AND customer_id != '$post[customer_id]'");
        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('no_wa_check', '%s Ini sudah dipakai, Silahkan ganti !');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    function no_ktp_check()
    {
        $post = $this->input->post(null, TRUE);
        $query = $this->db->query("SELECT * FROM customer WHERE no_ktp = '$post[no_ktp]' AND customer_id != '$post[customer_id]'");
        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('no_ktp_check', '%s Ini sudah dipakai, Silahkan ganti !');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function delete()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['del_customer'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);
        $customer_id = $this->input->post('customer_id');
        $no_services = $this->input->post('no_services');
        $cekConfir = $this->db->get_where('confirm_payment', ['no_services' => $no_services])->row_array();
        if ($cekConfir > 0) {
            $this->session->set_flashdata('error', 'Pelanggan tidak bisa dihapus dikarenakan masih ada di konfirmasi pembayaran');
            redirect('customer');
        }
        $query = $this->services_m->getServices($no_services);
        if ($query->num_rows() > 0) {
            $this->session->set_flashdata('error', 'Pelanggan tidak bisa dihapus dikarenakan masih ada daftar layanan yang aktif');
            redirect('customer');
        } else {
            $cekInvoice = $this->bill_m->getCekInvoice($no_services);
            if ($cekInvoice->num_rows() > 0) {
                $this->session->set_flashdata('error', 'Pelanggan tidak bisa dihapus dikarenakan data-nya masih digunakan di detail tagihan !');
                redirect('customer');
            } else {
                $customer = $this->db->get_where('customer', ['no_services' => $no_services])->row_array();
                if ($customer['ktp'] != null) {
                    $target_file = './assets/images/ktp/' . $customer['ktp'];

                    unlink($target_file);
                }
                $this->customer_m->delete($customer_id);
                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Data berhasil dihapus');
                }
                redirect('customer');
            }
        }
    }

    public function setactive()
    {
        $this->db->set('c_status', 'Aktif');
        $this->db->update('customer');
        redirect('customer/active');
    }
    public function setallppn()
    {
        $this->db->set('ppn', 1);
        $this->db->where('c_status', 'Aktif');
        $this->db->update('customer');
        redirect('customer/active');
    }
    public function setduedate()
    {
        $company = $this->db->get('company')->row_array();
        $this->db->set('due_date', $company['due_date']);
        $this->db->where('due_date', 0);
        $this->db->update('customer');
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Berhasil');
        }
        redirect('customer');
    }
    public function delempty()
    {

        $this->db->where('no_services', '');
        $this->db->where('email', '');
        $this->db->delete('customer');
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Berhasil');
        }
        redirect('customer');
    }
    public function import()
    {
        $data = array(); // Buat variabel $data sebagai array

        if (isset($_POST['preview'])) { // Jika user menekan tombol Preview pada form
            // lakukan upload file dengan memanggil function upload yang ada di SiswaModel.php
            $upload = $this->customer_m->upload_file('import_data');

            if ($upload['result'] == "success") { // Jika proses upload sukses
                // Load plugin PHPExcel nya
                include APPPATH . 'third_party/PHPExcel/PHPExcel.php';

                $excelreader = new PHPExcel_Reader_Excel2007();
                $loadexcel = $excelreader->load('assets/import_data.xlsx'); // Load file yang tadi diupload ke folder excel
                $sheet = $loadexcel->getActiveSheet()->toArray(null, true, true, true);

                // Masukan variabel $sheet ke dalam array data yang nantinya akan di kirim ke file form.php
                // Variabel $sheet tersebut berisi data-data yang sudah diinput di dalam excel yang sudha di upload sebelumnya
                $data['sheet'] = $sheet;
            } else { // Jika proses upload gagal
                $data['upload_error'] = $upload['error']; // Ambil pesan error uploadnya untuk dikirim ke file form dan ditampilkan
                $this->session->set_flashdata('error-sweet', $upload['error']);
                redirect('customer/import');
            }
        }
        $data['title'] = 'Customer';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        // $this->load->view('form', $data);
        $this->template->load('backend', 'backend/excel/data', $data);
    }

    public function importtodatabase()
    {
        // Load plugin PHPExcel nya
        include APPPATH . 'third_party/PHPExcel/PHPExcel.php';

        $excelreader = new PHPExcel_Reader_Excel2007();
        $loadexcel = $excelreader->load('assets/import_data.xlsx'); // Load file yang telah diupload ke folder excel
        $sheet = $loadexcel->getActiveSheet()->toArray(null, true, true, true);

        // Buat sebuah variabel array untuk menampung array data yg akan kita insert ke database
        $data = array();

        $numrow = 1;
        foreach ($sheet as $row) {
            // Cek $numrow apakah lebih dari 1
            // Artinya karena baris pertama adalah nama-nama kolom
            // Jadi dilewat saja, tidak usah diimport
            if ($numrow > 1) {
                // Kita push (add) array data ke variabel data
                array_push($data, array(
                    'no_services' => trim($row['A']), // Insert data nis dari kolom A di excel
                    'name' => trim($row['B']), // Insert data nama dari kolom B di excel
                    'email' => trim($row['C']), // Insert data jenis kelamin dari kolom C di excel
                    'c_status' => trim($row['D']), // Insert data alamat dari kolom D di excel
                    'no_wa' => trim($row['E']), // Insert data alamat dari kolom D di excel
                    'address' => $row['F'], // Insert data alamat dari kolom D di excel
                    'no_ktp' => trim($row['G']), // Insert data alamat dari kolom D di excel
                    'ppn' => trim($row['H']),
                    'due_date' => trim($row['I']), // Insert data alamat dari kolom D di excel
                    'router' => trim($row['K']), // Insert data alamat dari kolom D di excel
                    'mode_user' => trim($row['L']), // Insert data alamat dari kolom D di excel
                    'user_mikrotik' => trim($row['M']), // Insert data alamat dari kolom D di excel
                    'user_profile' => trim($row['N']), // Insert data alamat dari kolom D di excel
                    'auto_isolir' => trim($row['O']), // Insert data alamat dari kolom D di excel
                ));
            }
            $item = $this->db->get_where('package_item', ['p_item_id' => trim($row['J'])])->row_array();
            $datapaket = [
                'item_id' => $item['p_item_id'],
                'category_id' => $item['category_id'],
                'no_services' => trim($row['A']),
                'qty' => 1,
                'disc' => 0,
                'price' => $item['price'],
                'total' => $item['price'],
                'services_create' => time(),
            ];
            $this->db->insert('services', $datapaket);
            $numrow++; // Tambah 1 setiap kali looping

        }
        $this->db->where('no_services', '');
        $this->db->where('email', '');
        $this->db->delete('customer');
        // Panggil fungsi insert_multiple yg telah kita buat sebelumnya di model
        $this->customer_m->importfromexcel($data);
        $target_file = './assets/import_data.xlsx';

        unlink($target_file);
        redirect("customer"); // Redirect ke halaman awal (ke controller siswa fungsi index)
    }
    public function whatsapp()
    {
        $data['title'] = 'Whatsapp Pelanggan';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/customer/whatsapp', $data);
    }

    // SERVER SIDE
    public function getAllCustomer()
    {
        $result = $this->customer_m->getDataTable();
        $company = $this->db->get('company')->row_array();
        $data = [];
        $no = $_POST['start'];
        foreach ($result as $result) {
            if ($result->no_services != 0) {
                $query = "SELECT * FROM `services` WHERE `services`.`no_services` = $result->no_services";
            } else {
                $query = "SELECT * FROM `services` WHERE `services`.`email` = '$result->email'";
            }
            $querying = $this->db->query($query)->result();
            $subtotal = 0;
            foreach ($querying as  $dataa)
                $subtotal += $dataa->total;
            $row = array();
            $row[] = ++$no;

            $row[] = $result->no_services . '<br> <a href="' . site_url('services/detail/') . $result->no_services . '"  class="btn btn-success"  style="font-size: smaller">Rincian Paket</a> ';
            $row[] = $result->name;
            $row[] = $result->email;
            if ($result->phonecode == 0) {
                $phone = $company['phonecode'] . '' . $result->no_wa;
            } else {
                $phone =  $result->phonecode . '' . $result->no_wa;
            }
            $row[] = indo_tlp($result->no_wa);
            $row[] = $result->c_status;

            if ($result->ppn == 1) {
                $row[] = 'Yes';
            } else {
                $row[] = 'No';
            }
            if ($this->session->userdata('role_id') == 1) {



                $row[] = indo_currency($subtotal);
            }
            $row[] = $result->address;

            $row[] = '
                       <a href="' . site_url('customer/edit/') . $result->customer_id . '" title="Edit"><i class="fa fa-edit" style="font-size:25px"></i></a> 
                       <a href="#" id="delete" data-customer_id="' . $result->customer_id . '" data-no_services="' . $result->no_services . ' " data-name=' . $result->name . ' data-toggle="modal" data-target="#DeleteModal"   title="Delete" ><i class="fa fa-trash" style="font-size:25px; color:red"></i></a> 
                       ';


            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->db->get('customer')->num_rows(),
            "recordsFiltered" => $this->customer_m->count_filtered_data(),
            "data" => $data,
        );

        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }
    public function getActiveCustomer()
    {
        $result = $this->customer_m->getActive();
        $data = [];
        $company = $this->db->get('company')->row_array();
        $no = $_POST['start'];
        foreach ($result as $result) {
            $query = "SELECT * FROM `services` WHERE `services`.`no_services` = $result->no_services";
            $querying = $this->db->query($query)->result();
            $subtotal = 0;
            foreach ($querying as  $dataa)
                $subtotal +=  $dataa->total;
            $row = array();
            $row[] = ++$no;

            $row[] = $result->no_services . '<br> <a href="' . site_url('services/detail/') . $result->no_services . '"  class="btn btn-success"  style="font-size: smaller">Rincian Paket</a> ';
            $row[] = $result->name;
            $row[] = $result->email;
            if ($result->phonecode == 0) {
                $phone = $company['phonecode'] . '' . $result->no_wa;
            } else {
                $phone =  $result->phonecode . '' . $result->no_wa;
            }
            $row[] = indo_tlp($result->no_wa);
            $row[] = $result->c_status;

            if ($result->ppn == 1) {
                $row[] = 'Yes';
            } else {
                $row[] = 'No';
            }

            if ($this->session->userdata('role_id') == 1) {
                $row[] = indo_currency($subtotal);
            }
            $row[] = $result->address;

            $row[] = '
                       <a href="' . site_url('customer/edit/') . $result->customer_id . '" title="Edit"><i class="fa fa-edit" style="font-size:25px"></i></a> 
                       <a href="#" id="delete" data-customer_id="' . $result->customer_id . '" data-no_services="' . $result->no_services . ' " data-name=' . $result->name . ' data-toggle="modal" data-target="#DeleteModal"   title="Delete" ><i class="fa fa-trash" style="font-size:25px; color:red"></i></a> 
                       ';


            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->db->get_where('customer', ['c_status' => 'Aktif'])->num_rows(),
            "recordsFiltered" => $this->customer_m->count_filtered_data_active(),
            "data" => $data,
        );

        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }
    public function getNonActiveCustomer()
    {
        $result = $this->customer_m->getNonActive();
        $data = [];
        $no = $_POST['start'];
        foreach ($result as $result) {
            $query = "SELECT * FROM `services` WHERE `services`.`no_services` = $result->no_services";
            $querying = $this->db->query($query)->result();
            $subtotal = 0;
            foreach ($querying as  $dataa)
                $subtotal +=  $dataa->total;
            $row = array();
            $row[] = ++$no;

            $row[] = $result->no_services . '<br> <a href="' . site_url('services/detail/') . $result->no_services . '"  class="btn btn-success"  style="font-size: smaller">Rincian Paket</a> ';
            $row[] = $result->name;
            $row[] = $result->email;
            $company = $this->db->get('company')->row_array();
            if ($result->phonecode == 0) {
                $phone = $company['phonecode'] . '' . $result->no_wa;
            } else {
                $phone =  $result->phonecode . '' . $result->no_wa;
            }
            $row[] = $phone;
            $row[] = $result->c_status;

            if ($result->ppn == 1) {
                $row[] = 'Yes';
            } else {
                $row[] = 'No';
            }

            if ($this->session->userdata('role_id') == 1) {

                $row[] = indo_currency($subtotal);
            }
            $row[] = $result->address;

            $row[] = '
                       <a href="' . site_url('customer/edit/') . $result->customer_id . '" title="Edit"><i class="fa fa-edit" style="font-size:25px"></i></a> 
                       <a href="#" id="delete" data-customer_id="' . $result->customer_id . '" data-no_services="' . $result->no_services . ' " data-name=' . $result->name . ' data-toggle="modal" data-target="#DeleteModal"   title="Delete" ><i class="fa fa-trash" style="font-size:25px; color:red"></i></a> 
                       ';

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->db->get_where('customer', ['c_status' => 'Non-Aktif'])->num_rows(),
            "recordsFiltered" => $this->customer_m->count_filtered_data_nonactive(),
            "data" => $data,
        );

        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }
    public function getWaitCustomer()
    {
        $result = $this->customer_m->getWait();
        $data = [];
        $no = $_POST['start'];
        foreach ($result as $result) {
            if ($result->no_services != 0) {
                $query = "SELECT * FROM `services` WHERE `services`.`no_services` = $result->no_services";
            } else {
                $query = "SELECT * FROM `services` WHERE `services`.`email` = '$result->email'";
            }
            $querying = $this->db->query($query)->result();
            $subtotal = 0;
            foreach ($querying as  $dataa)
                $subtotal +=  $dataa->total;
            $row = array();
            $row[] = ++$no;

            $row[] = $result->no_services . '<br> <a href="' . site_url('services/detail/') . $result->no_services . '"  class="btn btn-success"  style="font-size: smaller">Package</a> ';
            $row[] = $result->name;
            $row[] = $result->email;
            $company = $this->db->get('company')->row_array();
            if ($result->phonecode == 0) {
                $phone = $company['phonecode'] . '' . $result->no_wa;
            } else {
                $phone =  $result->phonecode . '' . $result->no_wa;
            }
            $row[] = indo_tlp($result->no_wa);
            $row[] = $result->c_status;
            if ($result->ppn == 1) {
                $row[] = 'Yes';
            } else {
                $row[] = 'No';
            }
            if ($this->session->userdata('role_id') == 1) {

                $row[] = indo_currency($subtotal);
            }
            $row[] = $result->address;

            $row[] = '
                       <a href="' . site_url('customer/edit/') . $result->customer_id . '" title="Edit"><i class="fa fa-edit" style="font-size:25px"></i></a> 
                       <a href="#" id="delete" data-customer_id="' . $result->customer_id . '" data-no_services="' . $result->no_services . ' " data-name=' . $result->name . ' data-toggle="modal" data-target="#DeleteModal"   title="Delete" ><i class="fa fa-trash" style="font-size:25px; color:red"></i></a> 
                       ';

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->db->get_where('customer', ['c_status' => 'Menunggu'])->num_rows(),
            "recordsFiltered" => $this->customer_m->count_filtered_data_waiting(),
            "data" => $data,
        );

        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }
}
