<?php defined('BASEPATH') or exit('No direct script access allowed');

class expenditure extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        is_logged_in();
        $this->load->model(['expenditure_m']);
    }


    public function index()
    {
        $data['title'] = 'Expenditure';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['expenditure'] = $this->expenditure_m->getexpenditure()->result();
        $data['category'] = $this->expenditure_m->getcategory()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/expenditure/expenditure', $data);
    }
    public function category()
    {
        $data['title'] = 'Expenditure Category';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['category'] = $this->expenditure_m->getcategory()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/expenditure/cat_expenditure', $data);
    }

    public function add()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['add_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);
        $this->expenditure_m->add($post);

        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data pengeluaran berhasil ditambahkan');
        }
        echo "<script>window.location='" . site_url('expenditure') . "'; </script>";
    }
    public function addcategory()
    {

        $post = $this->input->post(null, TRUE);
        $this->expenditure_m->addcategory($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data kategori pengeluaran berhasil ditambahkan');
        }
        echo "<script>window.location='" . site_url('expenditure/category') . "'; </script>";
    }
    public function edit()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['edit_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);

        $this->expenditure_m->edit($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data pengeluaran berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('expenditure') . "'; </script>";
    }
    public function editcategory()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['edit_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $post = $this->input->post(null, TRUE);

        $this->expenditure_m->editcategory($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data kategori pengeluaran berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('expenditure/category') . "'; </script>";
    }
    public function delete()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['del_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $expenditure_id = $this->input->post('expenditure_id');

        $this->expenditure_m->delete($expenditure_id);

        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data pengeluaran berhasil dihapus');
        }
        echo "<script>window.location='" . site_url('expenditure') . "'; </script>";
    }
    public function deletecategory()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['del_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $category_id = $this->input->post('category_id');
        $cekkategori = $this->db->get_where('expenditure', ['category' => $category_id])->row_array();
        if ($cekkategori > 0) {
            $this->session->set_flashdata('error', 'Kategori tidak dapat dihapus karena terdaftar di data pengeluaran');
        } else {
            # code...
            $this->expenditure_m->deletecategory($category_id);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data kategori pengeluaran berhasil dihapus');
            }
        }

        echo "<script>window.location='" . site_url('expenditure/category') . "'; </script>";
    }
    public function printexpenditure()
    {
        $post = $this->input->post(null, TRUE);
        $data['tanggal'] = $this->input->post('tanggal');
        $data['tanggal2'] = $this->input->post('tanggal2');
        $data['category'] = $this->input->post('category');
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['expenditure'] = $this->expenditure_m->getFilter($post)->result();
        $this->load->view('backend/expenditure/printexpenditure', $data);
    }

    public function delselected()
    {
        $expenditure_id =  $_POST['expenditure_id'];
        if ($expenditure_id == null) {
            $this->session->set_flashdata('error', 'Belum ada yang dipilih');
        } else {
            $this->expenditure_m->deleteselected($expenditure_id);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data Pengeluaran berhasil dihapus');
            }
        }
        redirect('expenditure');
    }

    public function filter()
    {
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Filter Expenditure';
        $data['category'] = $this->expenditure_m->getcategory()->result();
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['expenditure'] = $this->expenditure_m->getFilterMonth($post)->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/expenditure/filter', $data);
    }
}
