<?php defined('BASEPATH') or exit('No direct script access allowed');

class Router extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        is_logged_in();
        $this->load->model(['router_m']);
    }

    public function index()
    {

        $data['title'] = 'Router';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['router'] = $this->db->get('router')->row_array();
        $this->template->load('backend', 'backend/router/data', $data);
    }
    public function customer()
    {

        $data['title'] = 'Customer Router';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['customer'] = $this->db->get('customer')->result();
        $this->template->load('backend', 'backend/router/customer', $data);
    }

    public function edit()
    {
        $post = $this->input->post(null, true);
        $this->router_m->edit($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data router berhasil diperbaharui');
        }
        redirect('router');
    }
    public function editcustomer()
    {
        $post = $this->input->post(null, true);
        $this->router_m->editcustomer($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Pelanggan berhasil diperbaharui');
        }
        redirect('router/customer');
    }

    public function client($no_services)
    {
        $data['title'] = 'Client';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['customer'] = $this->db->get_where('customer', ['no_services' => $no_services])->row_array();
        $this->template->load('backend', 'backend/router/client', $data);
    }

    public function openisolirhotspot($id)
    {

        $router = $this->db->get('router')->row_array();
        $ip = $router['ip_address'];
        $username = $router['username'];
        $password = $router['password'];
        $port = $router['port'];
        $API = new Mikweb();

        $API->connect($ip, $username, $password, $port);

        $API->comm("/ip/hotspot/user/enable", array(
            ".id" => '*' . $id,
        ));

        redirect($_SERVER['HTTP_REFERER']);
    }

    public function isolirhotspot($id)
    {

        $router = $this->db->get('router')->row_array();
        $ip = $router['ip_address'];
        $username = $router['username'];
        $password = $router['password'];
        $port = $router['port'];
        $API = new Mikweb();
        $API->connect($ip, $username, $password, $port);

        $API->comm("/ip/hotspot/user/disable", array(
            ".id" => '*' . $id,
        ));

        redirect($_SERVER['HTTP_REFERER']);
    }
}
