<?php defined('BASEPATH') or exit('No direct script access allowed');
class Coverage_m extends CI_Model
{
    public function getCoverage()
    {
        $this->db->select('*');
        $this->db->from('coverage');

        $this->db->order_by('c_name', 'ASC');
        $query = $this->db->get();
        return $query;
    }
    public function add($post)
    {
        $params = [
            'c_name' => $post['name'],

            'address' => $post['address'],
            'comment' => $post['comment'],

        ];
        $this->db->insert('coverage', $params);
    }
    public function edit($post)
    {
        $params = [
            'c_name' => $post['name'],

            'address' => $post['address'],
            'comment' => $post['comment'],

        ];
        $this->db->where('coverage_id', $post['coverage_id']);
        $this->db->update('coverage', $params);
    }



    public function del($post)
    {
        $this->db->where('coverage_id', $post['coverage_id']);
        $this->db->delete('coverage');
    }

    public function getCustomer($coverage)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($coverage != null) {
            $this->db->where('coverage', $coverage);
        }
        $this->db->order_by('name', 'ASC');
        $query = $this->db->get();
        return $query;
    }
}
