<?php defined('BASEPATH') or exit('No direct script access allowed');

class Customer_m extends CI_Model
{
    var $table = 'customer';
    var $column_order = array('name', 'no_services', 'no_wa', 'email', 'address');
    var $order = array('name', 'no_services', 'no_wa', 'email', 'address');

    public function getCustomer($customer_id = null, $no_services = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($customer_id != null) {
            $this->db->where('customer_id', $customer_id);
        }
        if ($no_services != null) {
            $this->db->where('no_services', $no_services);
        }
        $this->db->order_by('name', 'ASC');
        $query = $this->db->get();
        return $query;
    }
    public function getCustomerSelecteddraf($noservices = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($noservices != null) {
            $this->db->where_in('no_services', $noservices);
        }
        $this->db->where('c_status', 'Aktif');
        $query = $this->db->get();
        return $query;
    }
    public function getfilterby($post)
    {
        $this->db->select('*');
        $this->db->from('customer');
        $this->db->where('c_status', $post['status']);

        if ($post['coverage'] != 0) {
            $this->db->where('coverage', $post['coverage']);
        }
        $this->db->order_by('name', 'ASC');
        $query = $this->db->get();
        return $query;
    }
    public function getgenerateupdate($post)
    {

        $this->db->select('*');
        $this->db->from('customer');
        $this->db->join('invoice', 'customer.no_services = invoice.no_services');
        $this->db->where('c_status', 'Aktif');
        $this->db->where('month !=', $post['month']);
        $this->db->where('year !=', $post['year']);

        $query = $this->db->get();
        return $query;
    }
    public function getCustomerActive($customer_id = null, $no_services = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($customer_id != null) {
            $this->db->where('customer_id', $customer_id);
        }
        if ($no_services != null) {
            $this->db->where('no_services', $no_services);
        }
        $this->db->where('c_status', 'Aktif');
        $query = $this->db->get();
        return $query;
    }
    public function getCustomerNonactive($customer_id = null, $no_services = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($customer_id != null) {
            $this->db->where('customer_id', $customer_id);
        }
        if ($no_services != null) {
            $this->db->where('no_services', $no_services);
        }
        $this->db->where('c_status', 'Non-Aktif');
        $query = $this->db->get();
        return $query;
    }
    public function getCustomerWait($customer_id = null, $no_services = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($customer_id != null) {
            $this->db->where('customer_id', $customer_id);
        }
        if ($no_services != null) {
            $this->db->where('no_services', $no_services);
        }
        $this->db->where('c_status', 'Menunggu');
        $query = $this->db->get();
        return $query;
    }



    public function getNSCustomer($no_services = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($no_services != null) {
            $this->db->where('no_services', $no_services);
        }
        $query = $this->db->get();
        return $query;
    }
    public function getNSCustomerdraf($no_services = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($no_services != null) {
            $this->db->where_in('no_services', $no_services);
        }
        $query = $this->db->get();
        return $query;
    }
    public function getInvoiceCustomer($no_services = null)
    {
        $this->db->select('*');
        $this->db->from('customer');
        if ($no_services != null) {
            $this->db->where('no_services', $no_services);
        }
        $query = $this->db->get();
        return $query;
    }
    public function add($post)
    {
        $params = [
            'name' => htmlspecialchars($post['name']),
            'no_services' => $post['no_services'],
            'no_ktp' => $post['no_ktp'],
            'type_id' => $post['type_id'],
            'email' => $post['email'],
            'ppn' => $post['ppn'],
            'no_wa' => $post['no_wa'],
            'due_date' => $post['due_date'],
            'coverage' => $post['coverage'],
            'mode_user' => $post['mode_user'],
            'user_mikrotik' => $post['user_mikrotik'],
            'c_status' => $post['status'],
            'address' => htmlspecialchars($post['address']),
            'created' => time(),
        ];
        $this->db->insert('customer', $params);
    }

    public function addregist($post)
    {
        $params = [
            'name' => htmlspecialchars($post['name']),
            'no_ktp' => $post['no_ktp'],
            'email' => $post['email'],
            'type_id' => $post['type_id'],
            'no_services' => $post['no_services'],
            'no_wa' => $post['no_wa'],
            'c_status' => 'Menunggu',
            'address' => htmlspecialchars($post['address']),
            'created' => time(),
        ];
        $this->db->insert('customer', $params);
    }
    // Fungsi untuk melakukan proses upload file
    public function upload_file($filename)
    {
        $this->load->library('upload'); // Load librari upload
        $config['upload_path'] = './assets/';
        $config['allowed_types'] = 'xlsx';
        $config['max_size']    = '5000';
        $config['overwrite'] = true;
        $config['file_name'] = $filename;

        $this->upload->initialize($config); // Load konfigurasi uploadnya
        if ($this->upload->do_upload('file')) { // Lakukan upload dan Cek jika proses upload berhasil
            // Jika berhasil :
            $return = array('result' => 'success', 'file' => $this->upload->data(), 'error' => '');
            return $return;
        } else {
            // Jika gagal :
            $return = array('result' => 'failed', 'file' => '', 'error' => $this->upload->display_errors());
            return $return;
        }
    }
    // Buat sebuah fungsi untuk melakukan insert lebih dari 1 data
    public function importfromexcel($data)
    {
        $this->db->insert_batch('customer', $data);
    }
    public function edit($post)
    {
        $params = [
            'name' => htmlspecialchars($post['name']),
            'no_ktp' => $post['no_ktp'],
            'email' => $post['email'],
            'ppn' => $post['ppn'],
            'no_wa' => $post['no_wa'],
            'due_date' => $post['due_date'],
            'coverage' => $post['coverage'],
            'mode_user' => $post['mode_user'],
            'user_mikrotik' => $post['user_mikrotik'],
            'c_status' => $post['status'],
            'address' => htmlspecialchars($post['address']),
        ];
        $this->db->where('customer_id', $post['customer_id']);
        $this->db->update('customer', $params);
    }


    public function delete($customer_id)
    {
        $this->db->where('customer_id', $customer_id);
        $this->db->delete('customer');
    }


    // SERVER SIDE
    private function _get_data_query()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($this->session->userdata('role_id') == 3 && $role['coverage_operator'] == 1) {
            $operator = $this->db->get_where('cover_operator', ['operator' => $this->session->userdata('id')])->result();

            foreach ($operator as $roww) {
                $row[] = $roww->coverage_id;
            };
            // var_dump($row);
            // die;
            $this->db->from($this->table);
            $this->db->where_in('coverage', $row);
            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                // $this->db->or_like('no_services', $_POST['search']['value']);
            }
        } else {
            $this->db->from($this->table);

            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                $this->db->or_like('name', $_POST['search']['value']);
                $this->db->or_like('no_services', $_POST['search']['value']);
                $this->db->or_like('no_wa', $_POST['search']['value']);
                $this->db->or_like('email', $_POST['search']['value']);
                $this->db->or_like('address', $_POST['search']['value']);
            }
        }




        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('name', 'ASC');
        }
    }
    private function _get_data_queryactive()
    {

        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($this->session->userdata('role_id') == 3 && $role['coverage_operator'] == 1) {
            $operator = $this->db->get_where('cover_operator', ['operator' => $this->session->userdata('id')])->result();

            foreach ($operator as $roww) {
                $row[] = $roww->coverage_id;
            };
            // var_dump($row);
            // die;
            $this->db->from($this->table);
            $this->db->where('c_status', 'Aktif');
            $this->db->where_in('coverage', $row);
            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                $this->db->where('c_status', 'Aktif');
                // $this->db->or_like('no_services', $_POST['search']['value']);
            }
        } else {
            $this->db->from($this->table);
            $this->db->where('c_status', 'Aktif');
            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                $this->db->or_like('no_services', $_POST['search']['value']);
                // $this->db->or_like('email', $_POST['search']['value']);
                // $this->db->or_like('no_wa', $_POST['search']['value']);
                // $this->db->or_like('address', $_POST['search']['value']);
                $this->db->where('c_status', 'Aktif');
            }
        }

        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('name', 'ASC');
        }
    }
    public function getDataTable()
    {
        $this->_get_data_query();
        if ($_POST['lengt'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    public function getActive()
    {

        $this->_get_data_queryactive();
        if ($_POST['lengt'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    public function getNonActive()
    {

        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($this->session->userdata('role_id') == 3 && $role['coverage_operator'] == 1) {
            $operator = $this->db->get_where('cover_operator', ['operator' => $this->session->userdata('id')])->result();

            foreach ($operator as $roww) {
                $row[] = $roww->coverage_id;
            };
            // var_dump($row);
            // die;
            $this->db->from($this->table);
            $this->db->where('c_status', 'Non-Aktif');
            $this->db->where_in('coverage', $row);
            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                $this->db->where('c_status', 'Non-Aktif');
                // $this->db->or_like('no_services', $_POST['search']['value']);
            }
        } else {
            $this->db->from($this->table);
            $this->db->where('c_status', 'Non-Aktif');
            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                $this->db->or_like('no_services', $_POST['search']['value']);
                $this->db->where('c_status', 'Non-Aktif');
            }
        }

        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('name', 'ASC');
        }

        if ($_POST['lengt'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    public function getWait()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($this->session->userdata('role_id') == 3 && $role['coverage_operator'] == 1) {
            $operator = $this->db->get_where('cover_operator', ['operator' => $this->session->userdata('id')])->result();

            foreach ($operator as $roww) {
                $row[] = $roww->coverage_id;
            };
            // var_dump($row);
            // die;
            $this->db->from($this->table);
            $this->db->where('c_status', 'Menunggu');
            $this->db->where_in('coverage', $row);
            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                $this->db->where('c_status', 'Menunggu');
            }
        } else {
            $this->db->from($this->table);
            $this->db->where('c_status', 'Menunggu');
            if (isset($_POST['search']['value'])) {
                $this->db->like('name', $_POST['search']['value']);
                $this->db->or_like('no_services', $_POST['search']['value']);
                $this->db->where('c_status', 'Menunggu');
            }
        }

        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('name', 'ASC');
        }

        if ($_POST['lengt'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    public function count_filtered_data()
    {
        $this->_get_data_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function count_filtered_data_active()
    {
        $this->db->from($this->table);
        $this->db->where('c_status', 'Aktif');
        if (isset($_POST['search']['value'])) {
            $this->db->like('name', $_POST['search']['value']);
            $this->db->where('c_status', 'Aktif');
            $this->db->or_like('no_services', $_POST['search']['value']);
        }


        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('name', 'ASC');
        }
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function count_filtered_data_nonactive()
    {
        $this->db->from($this->table);
        $this->db->where('c_status', 'Non-Aktif');
        if (isset($_POST['search']['value'])) {
            $this->db->like('name', $_POST['search']['value']);
            $this->db->where('c_status', 'Non-Aktif');
            $this->db->or_like('no_services', $_POST['search']['value']);
        }


        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('name', 'ASC');
        }
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function count_filtered_data_waiting()
    {
        $this->db->from($this->table);
        $this->db->where('c_status', 'Menunggu');
        if (isset($_POST['search']['value'])) {
            $this->db->like('name', $_POST['search']['value']);
            $this->db->where('c_status', 'Menunggu');
            $this->db->or_like('no_services', $_POST['search']['value']);
        }


        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $this->db->order_by('name', 'ASC');
        }
        $query = $this->db->get();
        return $query->num_rows();
    }
}
