<div class="col-lg-6">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold">Tambah Pelanggan</h6>
        </div>
        <div class="card-body">
            <?php echo form_open_multipart('customer/add') ?>
            <div class="form-group">
                <label for="name">Nama Pelanggan</label>
                <input type="text" id="name" name="name" class="form-control" value="<?= set_value('name') ?>">
                <?= form_error('name', '<small class="text-danger pl-3 ">', '</small>') ?>
            </div>
            <div class="form-group">

                <label for="no_services">No Layanan</label>

                <div class="input-group mb-3">
                    <input type="number" id="no_services" name="no_services" class="form-control" value="<?= set_value('no_services') ?>" onchange="NoServices()">
                    <div class="input-group-append">
                        <span id="generatenoservices" class="input-group-text">Generate</span>
                    </div>
                </div>


                <?= form_error('no_services', '<small class="text-danger pl-3 ">', '</small>') ?>

            </div>
            <div class="form-group">
                <label for="email">Email</label>
                <input type="text" id="email" name="email" class="form-control" value="<?= set_value('email') ?>">
                <?= form_error('email', '<small class="text-danger pl-3 ">', '</small>') ?>
            </div>
            <div class="form-group row">
                <div class="col-sm-6 mb-3 mb-sm-0">
                    <input type="password" class="form-control form-control-user" id="Password1" name="password1" placeholder="Password">
                    <?= form_error('password1', '<small class="text-danger pl-3 ">', '</small>') ?>
                </div>
                <div class="col-sm-6">
                    <input type="password" class="form-control form-control-user" id="Password2" name="password2" placeholder="Konfirmasi Password">
                </div>
            </div>
            <label for="no_ktp">ID Card</label>
            <div class="form-group row">
                <div class="col-sm-4 mb-3 mb-sm-0">
                    <select name="type_id" id="type_id" class="form-control" required>
                        <option value="">-Pilih-</option>
                        <option value="KTP">KTP</option>
                        <option value="SIM">SIM</option>
                        <option value="NPWP">NPWP</option>
                        <option value="Pasport">Pasport</option>
                    </select>
                </div>
                <div class="col-sm-8">
                    <input type="text" id="no_ktp" name="no_ktp" class="form-control" value="<?= set_value('no_ktp') ?>">
                    <?= form_error('no_ktp', '<small class="text-danger pl-3 ">', '</small>') ?>
                </div>
            </div>
            <div class="form-group">
                <label for="no_wa">No Telp.</label>
                <input type="number" id="no_wa" name="no_wa" class="form-control" value="<?= set_value('no_wa') ?>">
                <?= form_error('no_wa', '<small class="text-danger pl-3 ">', '</small>') ?>
            </div>
            <div class="form-group">
                <label for="due_date">Jatuh Tempo</label> <span style="font-size:12px;color:red; ">* 0 - 28</span>
                <input type="number" id="due_date" name="due_date" autocomplete="off" class="form-control" min="0" max="28" value="<?= set_value('due_date') ?>">
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select name="status" id="" class="form-control" required>
                    <option value="">-Pilih-</option>
                    <option value="Aktif">Aktif</option>
                    <option value="Non-Aktif">Non-Aktif</option>
                    <option value="Menunggu">Menunggu</option>
                </select>
            </div>
            <div class="form-group">
                <label for="ppn">PPN</label>
                <select class="form-control" id="ppn" name="ppn" required>
                    <option value="">-Pilih-</option>
                    <option value="1">Yes</option>
                    <option value="0">No</option>
                </select>
            </div>
            <div class="form-group">
                <label for="coverage">Coverage Area</label>
                <select name="coverage" id="coverage" class="form-control">
                    <?php if ($customer->coverage == 0) { ?>
                        <option value="">-Pilih-</option>
                    <?php } ?>
                    <?php if ($customer->coverage != 0) { ?>
                        <?php $datacoverage = $this->db->get_where('coverage', ['coverage_id' => $customer->coverage])->row_array(); ?>
                        <option value="<?= $customer->coverage ?>"><?= $datacoverage['c_name'] ?></option>
                    <?php } ?>
                    <?php foreach ($coverage as $data) { ?>
                        <option value="<?= $data->coverage_id ?>"><?= $data->c_name ?></option>
                    <?php } ?>
                </select>
            </div>
            <div class="form-group">
                <label for="paket">Paket Langganan</label>
                <?php $item = $this->db->get_where('package_item')->result() ?>
                <select name="paket" id="paket" class="form-control" required>
                    <option value="">-Pilih Paket-</option>
                    <?php foreach ($item as $item) { ?>
                        <option value="<?= $item->p_item_id ?>"><?= $item->name ?> - Rp. <?= indo_currency($item->price); ?></option>
                    <?php } ?>
                </select>
            </div>
            <div class="form-group">
                <label for="mode_user">Mode User</label>
                <select name="mode_user" id="mode_user" class="form-control">
                    <option value="">-Pilih-</option>
                    <option value="PPPOE">PPPOE</option>
                    <option value="Hotspot">Hotspot</option>
                    <option value="Static">Static</option>
                </select>
            </div>
            <div class="form-group">
                <label for="mode_user">User</label>
                <input type="text" autocomplete="off" id="user_mikrotik" name="user_mikrotik" class="form-control" value="<?= set_value('user_mikrotik') ?>">

            </div>
            <div class="form-group">
                <label for="address">Alamat</label>
                <textarea id="address" name="address" class="form-control"></textarea>
            </div>

            <div class="modal-footer">
                <button type="reset" class="btn btn-secondary" data-dismiss="modal">Reset</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
            <?php echo form_close() ?>
        </div>
    </div>
</div>

<script>
    $(function() {
        $("#generatenoservices").click(function() {
            var m = new Date();
            var th = m.getFullYear().toString().substr(-2);
            var dateString =
                th +
                ("0" + (m.getMonth() + 1)).slice(-2) +
                ("0" + m.getDate()).slice(-2) +
                ("0" + m.getHours()).slice(-2) +
                ("0" + m.getMinutes()).slice(-2) +
                ("0" + m.getSeconds()).slice(-2);

            $("#no_services").val(dateString);

        });
    });
</script>