<div class="col-lg-6">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold">Edit Pelanggan</h6>
        </div>
        <div class="card-body">
            <?php echo form_open_multipart('') ?>
            <div class="form-group">
                <label for="name">Nama Pelanggan</label>
                <input type="hidden" name="customer_id" value="<?= $customer->customer_id ?>" readonly>
                <input type="text" id="name" name="name" class="form-control" value="<?= $customer->name ?>">
                <?= form_error('name', '<small class="text-danger pl-3 ">', '</small>') ?>
            </div>
            <div class="form-group">
                <label for="email">Email</label>
                <input type="text" id="email" name="email" class="form-control" value="<?= $customer->email ?>">
                <?= form_error('email', '<small class="text-danger pl-3 ">', '</small>') ?>
            </div>
            <div class="form-group">
                <label for="no_ktp">No KTP</label>
                <input type="number" id="no_ktp" name="no_ktp" class="form-control" value="<?= $customer->no_ktp ?>">
                <?= form_error('no_ktp', '<small class="text-danger pl-3 ">', '</small>') ?>
            </div>
            <div class="form-group">
                <label for="no_wa">No Telp.</label>
                <input type="number" id="no_wa" name="no_wa" class="form-control" value="<?= $customer->no_wa ?>">
                <?= form_error('no_wa', '<small class="text-danger pl-3 ">', '</small>') ?>
            </div>
            <div class="form-group">
                <label for="due_date">Jatuh Tempo</label><span style="font-size:12px;color:red; "> *Isi 0 jika semua pelanggan sama, </span>
                <input type="number" autocomplete="off" name="due_date" class="form-control" min="0" max="28" value="<?= $customer->due_date ?>">
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select name="status" id="" class="form-control" required>
                    <?php if ($customer->c_status == '') { ?>
                        <option value="">-Pilih-</option>
                    <?php } ?>
                    <?php if ($customer->c_status != '') { ?>
                        <option value="<?= $customer->c_status ?>"><?= $customer->c_status ?></option>
                    <?php } ?>
                    <option value="Aktif">Aktif</option>
                    <option value="Non-Aktif">Non-Aktif</option>
                    <option value="Menunggu">Menunggu</option>
                </select>
            </div>
            <div class="form-group">
                <label for="ppn">PPN</label>
                <select class="form-control" id="ppn" name="ppn">
                    <option value="<?= $customer->ppn; ?>"><?= $customer->ppn == 1 ? 'Yes' : 'No' ?></option>
                    <option value="1">Yes</option>
                    <option value="0">No</option>
                </select>
            </div>
            <div class="form-group">
                <label for="coverage">Coverage Area</label>
                <select name="coverage" id="coverage" class="form-control">
                    <?php if ($customer->coverage == 0) { ?>
                        <option value="">-Pilih-</option>
                    <?php } ?>
                    <?php if ($customer->coverage != 0) { ?>
                        <?php $datacoverage = $this->db->get_where('coverage', ['coverage_id' => $customer->coverage])->row_array(); ?>
                        <option value="<?= $customer->coverage ?>"><?= $datacoverage['c_name'] ?></option>
                    <?php } ?>
                    <?php foreach ($coverage as $data) { ?>
                        <option value="<?= $data->coverage_id ?>"><?= $data->c_name ?></option>
                    <?php } ?>
                </select>
            </div>
            <div class="form-group">
                <label for="mode_user">Mode User</label>
                <select name="mode_user" id="mode_user" class="form-control">
                    <option value="<?= $customer->mode_user ?>"><?= $customer->mode_user ?></option>
                    <option value="PPPOE">PPPOE</option>
                    <option value="Hotspot">Hotspot</option>
                    <option value="Static">Static</option>
                </select>
            </div>
            <div class="form-group">
                <label for="mode_user">User</label>
                <input type="text" autocomplete="off" id="user_mikrotik" name="user_mikrotik" class="form-control" value="<?= $customer->user_mikrotik ?>">

            </div>

            <div class="form-group">
                <label for="address">Alamat</label>
                <textarea id="address" name="address" class="form-control"><?= $customer->address ?></textarea>
            </div>

            <div class="modal-footer">
                <button type="reset" class="btn btn-secondary" data-dismiss="modal">Reset</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
            <?php echo form_close() ?>
        </div>
    </div>
</div>