<?php defined('BASEPATH') or exit('No direct script access allowed');

class Coverage extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        is_logged_in();
        $this->load->model(['coverage_m']);
    }
    public function index()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['show_coverage'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Coverage Area';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['coverage'] = $this->coverage_m->getCoverage()->result();
        $data['company'] = $this->db->get('company')->row_array();
        
        $this->template->load('backend', 'backend/coverage/coverage', $data);
    }
    public function customer()
    {
        $data['title'] = 'Customer Area';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['coverage'] = $this->coverage_m->getCoverage()->result();
        $data['company'] = $this->db->get('company')->row_array();
        
        $this->template->load('backend', 'backend/coverage/coverage', $data);
    }
    public function add()
    {
        is_logged_in();
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['add_coverage'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('dashboard');
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);

        $this->coverage_m->add($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Coverage area berhasil ditambahkan');
        }
        echo "<script>window.location='" . site_url('coverage') . "'; </script>";
    }
    public function getKab($id_prov)
    {
        $kab = $this->coverage_m->getKab($id_prov);
        echo "<option value=''>Pilih Kota/Kab</option>";
        foreach ($kab as $k) {
            echo "<option value='{$k->id}'>{$k->nama}</option>";
        }
    }

    public function getKec($id_kab)
    {
        $kec = $this->coverage_m->getKec($id_kab);
        echo "<option value=''>Pilih Kecamatan</option>";
        foreach ($kec as $k) {
            echo "<option value='{$k->id}'>{$k->nama}</option>";
        }
    }

    public function getKel($id_kec)
    {
        $kel = $this->coverage_m->getKel($id_kec);
        echo "<option value=''>Pilih Kelurahan/Desa</option>";
        foreach ($kel as $k) {
            echo "<option value='{$k->id}'>{$k->nama}</option>";
        }
    }

    public function edit($id)
    {
        is_logged_in();
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['edit_coverage'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('dashboard');
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        if ($this->form_validation->run() == false) {
            $query  = $this->db->get_where('coverage', ['coverage_id' => $id]);
            if ($query->num_rows() > 0) {
                $data['title'] = 'Edit Coverage';
                $data['company'] = $this->db->get('company')->row_array();
                $data['coverage'] = $this->db->get_where('coverage', ['coverage_id' => $id])->row_array();
                
                $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
                $this->template->load('backend', 'backend/coverage/edit-coverage', $data);
            } else {
                echo "<script> alert ('Data tidak ditemukan');";
                echo "window.location='" . site_url('coverage') . "'; </script>";
            }
        } else {
            $post = $this->input->post(null, TRUE);
            $this->coverage_m->edit($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success-sweet', 'Data Coverage berhasil diperbaharui');
            }
            echo "<script>window.location='" . site_url('coverage') . "'; </script>";
        }
    }
    public function deletecoverage()
    {
        is_logged_in();
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id != 1 && $role['del_coverage'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('dashboard');
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);
        $cekcustomer = $this->db->get_where('customer', ['coverage' => $post['coverage_id']]);
        if ($cekcustomer->num_rows() > 0) {
            $this->session->set_flashdata('error-sweet', 'Tidak bisa dihapus karena masih terdaftar di data pelanggan');
        } else {
            $this->coverage_m->del($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success-sweet', 'Coverage Area berhasil dihapus');
            }
        }
        redirect('coverage');
    }

    public function cs($coverage)
    {
        $data['title'] = 'Customer Area';
        $data['cov'] = $coverage;
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['customer'] = $this->coverage_m->getCustomer($coverage)->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/coverage/customer', $data);
    }
}
