<?php defined('BASEPATH') or exit('No direct script access allowed');

class Income extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        is_logged_in();
        $this->load->model(['income_m', 'bill_m', 'customer_m', 'user_m', 'setting_m']);
    }


    public function index()
    {
        $data['title'] = 'Income';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['income'] = $this->income_m->getincome()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['category'] = $this->db->get('cat_income')->result();
        $this->template->load('backend', 'backend/income/income', $data);
    }


    public function add()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id == 3 && $role['add_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);
        $this->income_m->add($post);

        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data pemasukan berhasil ditambahkan');
        }
        echo "<script>window.location='" . site_url('income') . "'; </script>";
    }
    public function edit()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id == 3 && $role['edit_income'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $post = $this->input->post(null, TRUE);

        $this->income_m->edit($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data pemasukan berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('income') . "'; </script>";
    }
    public function delete()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id == 3 && $role['del_income'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $income_id = $this->input->post('income_id');

        $this->income_m->delete($income_id);

        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data pemasukan berhasil dihapus');
        }
        echo "<script>window.location='" . site_url('income') . "'; </script>";
    }
    public function category()
    {
        $data['title'] = 'Income Category';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['category'] = $this->income_m->getcategory()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/income/cat_income', $data);
    }
    public function addcategory()
    {
        $post = $this->input->post(null, TRUE);
        $this->income_m->addcategory($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data kategori pemasukan berhasil ditambahkan');
        }
        echo "<script>window.location='" . site_url('income/category') . "'; </script>";
    }
    public function editcategory()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id == 3 && $role['edit_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $post = $this->input->post(null, TRUE);

        $this->income_m->editcategory($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data kategori pemasukan berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('income/category') . "'; </script>";
    }
    public function deletecategory()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id == 3 && $role['del_income'] == 0) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $category_id = $this->input->post('category_id');
        $cekkategori = $this->db->get_where('income', ['category' => $category_id])->row_array();
        if ($cekkategori > 0) {
            $this->session->set_flashdata('error', 'Kategori tidak dapat dihapus karena terdaftar di data pemasukan');
        } else {
            # code...
            $this->income_m->deletecategory($category_id);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data kategori pemasukan berhasil dihapus');
            }
        }

        echo "<script>window.location='" . site_url('income/category') . "'; </script>";
    }
    public function printincome()
    {
        $post = $this->input->post(null, TRUE);
        $data['tanggal'] = $this->input->post('tanggal');
        $data['tanggal2'] = $this->input->post('tanggal2');
        $data['category'] = $this->input->post('category');
        $data['title'] = 'Invoice';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['income'] = $this->income_m->getFilter($post)->result();
        $this->load->view('backend/income/printincome', $data);
    }


    public function delselected()
    {
        $role_id = $this->session->userdata('role_id');
        $role = $this->db->get_where('role_management', ['role_id' => $role_id])->row_array();
        if ($role_id == 3 && $role['del_income'] == 0) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('role_id') == 2) {
            $this->session->set_flashdata('error', 'Akses dilarang');
            redirect('member/dashboard');
        }
        $income_id =  $_POST['income_id'];
        if ($income_id == null) {
            $this->session->set_flashdata('error', 'Belum ada yang dipilih');
        } else {
            $this->income_m->deleteselected($income_id);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data Pemasukan berhasil dihapus');
            }
        }
        redirect('income');
    }

    public function recap()
    {
        // $kolektor = $this->session->userdata('id');

        $data['title'] = 'Rekapitulasi';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        // $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['kolektor'] = $this->user_m->getcolector()->result();
        $data['detail'] = $this->bill_m->getInvoiceDetail()->result();
        $data['invoice'] = $this->bill_m->invoice_no();
        $data['bank'] = $this->setting_m->getBank()->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $this->template->load('backend', 'backend/income/recap', $data);
    }
    public function printrecap()
    {
        $post = $this->input->post(null, TRUE);
        $data['user_id'] = $this->input->post('user_id');
        $data['tanggal'] = $this->input->post('tanggal');
        $data['tanggal2'] = $this->input->post('tanggal2');
        $data['title'] = 'Cetak rekapituasi Kolktor';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['bill'] = $this->income_m->getFilterColector($post)->result();
        $this->load->view('backend/income/printrecap', $data);
    }
    public function filter()
    {
        $post = $this->input->post(null, TRUE);
        $data['title'] = 'Filter Income';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['income'] = $this->income_m->getFilterMonth($post)->result();
        $data['company'] = $this->db->get('company')->row_array();
        $data['category'] = $this->db->get('cat_income')->result();
        $this->template->load('backend', 'backend/income/filter', $data);
    }
    public function setcategory()
    {
        $this->db->set('category', 1);
        $this->db->like('remark', 'Pembayaran Tagihan no layanan');
        $this->db->update('income');
        redirect('income');
    }
    // SERVER SIDE
    public function getDataIncome()
    {
        $result = $this->income_m->getDataInc();
        $data = [];
        $no = $_POST['start'];
        foreach ($result as $result) {
            $row = array();
            $row[] = ++$no;
            $row[] = '<input type=' . 'checkbox' . ' class=' . 'check-item' . ' id="ceklis" name=' . 'income_id[]' . ' value=' . $result->income_id . '>';
            $row[] = indo_date($result->date_payment);
            $getcategory = $this->db->get_where('cat_income', ['category_id' => $result->category])->row_array();
            $row[] = indo_currency($result->nominal);
            if ($result->category != 0) {
                $row[] = $getcategory['name'];
            } else {
                $row[] = '';
            }
            $row[] = $result->remark;
            $row[] = '<a href="#" id="edit"  data-income_id="' . $result->income_id . '" data-nominal="' . $result->nominal . '" data-remark="' . $result->remark . '" data-category="' . $result->category . '" data-date_payment="' . $result->date_payment . '" title="Edit" data-toggle="modal" data-target="#Modaledit"><i class="fa fa-edit" style="font-size:25px"></i></a>
            <a  href="#" id="delete" data-toggle="modal" data-income_id="' . $result->income_id . '" data-nominal="' . indo_currency($result->nominal) . '" data-remark="' . $result->remark . '" data-date_payment="' . $result->date_payment . '" data-target="#Modaldelete"  title="Delete"><i class="fa fa-trash" style="font-size:25px; color:red"></i></a>';
            $data[] = $row;
        }
        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->income_m->count_all_data(),
            "recordsFiltered" => $this->income_m->count_filtered_data(),
            "data" => $data,
        );
        $this->output->set_content_type('application/json')->set_output(json_encode($output));
    }
}
