<?php
function is_logged_in()
{
    $ci = get_instance();
    if (!$ci->session->userdata('email')) {
        redirect('auth');
    }
}
function indo_currency($nominal)
{
    $result = number_format($nominal, 0, ',', '.');
    return $result;
}

function indo_tlp($nohp)
{
    // kadang ada penulisan no hp 0811 239 345
    $nohp = str_replace(" ", "", $nohp);
    // kadang ada penulisan no hp (0274) 778787
    $nohp = str_replace("(", "", $nohp);
    // kadang ada penulisan no hp (0274) 778787
    $nohp = str_replace(")", "", $nohp);
    // kadang ada penulisan no hp 0811.239.345
    $nohp = str_replace(".", "", $nohp);

    // cek apakah no hp mengandung karakter + dan 0-9
    if (!preg_match('/[^+0-9]/', trim($nohp))) {
        // cek apakah no hp karakter 1-3 adalah +62
        if (substr(trim($nohp), 0, 3) == '+62') {
            $nohp = trim($nohp);
        }
        // cek apakah no hp karakter 1 adalah 0
        elseif (substr(trim($nohp), 0, 1) == '0') {
            $nohp = '+62' . substr(trim($nohp), 1);
        }

        $result = $nohp;
        return $result;
    }
}
function indo_date($date)
{
    $d = substr($date, 8, 2);
    $m = substr($date, 5, 2);
    $y = substr($date, 0, 4);
    $bulan = Date($m);
    switch ($bulan) {
        case 01:
            $bulan = 'Januari';
            break;
        case 2:
            $bulan = 'Februari';
            break;
        case 3:
            $bulan = 'Maret';
            break;
        case 4:
            $bulan = 'April';
            break;
        case 5:
            $bulan = 'Mei';
            break;
        case 6:
            $bulan = 'Juni';
            break;
        case 7:
            $bulan = 'Juli';
            break;
        case 8:
            $bulan = 'Agustus';
            break;
        case 9:
            $bulan = 'September';
            break;
        case 10:
            $bulan = 'Oktober';
            break;
        case 11:
            $bulan = 'November';
            break;
        case 12:
            $bulan = 'Desember';
            break;
    }
    return $d . ' ' . $bulan . ' ' . $y;
}


if (!function_exists('number_to_words')) {
    function number_to_words($number)
    {
        $terbilang = trim(to_word($number));
        return ucwords($results = $terbilang);
    }

    function to_word($number)
    {
        $words = "";
        $arr_number = array(
            "",
            "satu",
            "dua",
            "tiga",
            "empat",
            "lima",
            "enam",
            "tujuh",
            "delapan",
            "sembilan",
            "sepuluh",
            "sebelas"
        );

        if ($number < 12) {
            $words = " " . $arr_number[$number];
        } else if ($number < 20) {
            $words = to_word($number - 10) . " belas";
        } else if ($number < 100) {
            $words = to_word($number / 10) . " puluh " . to_word($number % 10);
        } else if ($number < 200) {
            $words = "seratus " . to_word($number - 100);
        } else if ($number < 1000) {
            $words = to_word($number / 100) . " ratus " . to_word($number % 100);
        } else if ($number < 2000) {
            $words = "seribu " . to_word($number - 1000);
        } else if ($number < 1000000) {
            $words = to_word($number / 1000) . " ribu " . to_word($number % 1000);
        } else if ($number < 1000000000) {
            $words = to_word($number / 1000000) . " juta " . to_word($number % 1000000);
        } else {
            $words = "undefined";
        }
        return $words;
    }
}

function indo_month($month)
{
    $bulan = Date($month);
    switch ($bulan) {
        case 01:
            $bulan = 'Januari';
            break;
        case 2:
            $bulan = 'Februari';
            break;
        case 3:
            $bulan = 'Maret';
            break;
        case 4:
            $bulan = 'April';
            break;
        case 5:
            $bulan = 'Mei';
            break;
        case 6:
            $bulan = 'Juni';
            break;
        case 7:
            $bulan = 'Juli';
            break;
        case 8:
            $bulan = 'Agustus';
            break;
        case 9:
            $bulan = 'September';
            break;
        case 10:
            $bulan = 'Oktober';
            break;
        case 11:
            $bulan = 'November';
            break;
        case 12:
            $bulan = 'Desember';
            break;
    }
    return  $bulan;
}

function code_unique($nominal)
{
    $sub = substr($nominal, -3);
    $sub2 = substr($nominal, -2);
    $sub3 = substr($nominal, -1);

    $total =  random_string('numeric', 3);
    $total2 =  random_string('numeric', 2);
    $total3 =  random_string('numeric', 1);

    if ($sub == 0) {
        $hasil =  $nominal + $total;
        echo "No Unik :" . $total . "<br>";
        echo "Nominal Transfer : Rp. " . number_format($hasil, 0, ",", ".");
    } else if ($sub2 == 0) {
        $hasil = $nominal + $total2;
        $no = substr($hasil, -3);
        echo "No Unik :" . $no . "<br>";
        echo "Nominal Transfer : Rp. " . number_format($hasil, 0, ",", ".");
    } else if ($sub3 == 0) {
        $hasil = $nominal + $total3;
        $no = substr($hasil, -3);
        echo "No Unik :" . $no . "<br>";
        echo "Nominal Transfer : Rp. " . number_format($hasil, 0, ",", ".");
    } else {
        echo "No Unik :" . $sub . "<br>";
        echo "Nominal Transfer : Rp. " . number_format($nominal, 0, ",", ".");
    }
}
