<?php defined('BASEPATH') or exit('No direct script access allowed');
class expenditure_m extends CI_Model
{
    public function getexpenditure($expenditure_id = null)
    {
        $this->db->select('*');
        $this->db->from('expenditure');

        if ($expenditure_id != null) {
            $this->db->where('$expenditure_id', $expenditure_id);
        }
        $this->db->order_by('date_payment', 'DESC');
        $query = $this->db->get();
        return $query;
    }
    public function getcategory($category_id = null)
    {
        $this->db->select('*');
        $this->db->from('cat_expenditure');
        if ($category_id != null) {
            $this->db->where('category_id', $category_id);
        }
        $this->db->order_by('name', 'ASC');
        $query = $this->db->get();
        return $query;
    }
    public function getExpenditureThisMonth()
    {
        $this->db->select('*');
        $this->db->from('expenditure');
        $this->db->where('MONTH(date_payment)', date('m'));
        $this->db->where('YEAR(date_payment)', date('Y'));
        $query = $this->db->get();
        return $query;
    }


    public function add($post)
    {
        $params = [
            'nominal' => $post['nominal'],
            'category' => $post['category'],
            'date_payment' => htmlspecialchars($post['date_payment']),
            'remark' => htmlspecialchars($post['remark']),
            'created' => time()
        ];
        $this->db->insert('expenditure', $params);
    }
    public function addcategory($post)
    {
        $params = [
            'name' => $post['name'],
            'remark' => htmlspecialchars($post['remark']),
        ];
        $this->db->insert('cat_expenditure', $params);
    }
    public function edit($post)
    {
        $params = [
            'nominal' => $post['nominal'],
            'date_payment' => htmlspecialchars($post['date_payment']),
            'category' => $post['category'],
            'remark' => htmlspecialchars($post['remark']),
        ];
        $this->db->where('expenditure_id',  $post['expenditure_id']);
        $this->db->update('expenditure', $params);
    }
    public function editcategory($post)
    {
        $params = [
            'name' => $post['name'],

            'remark' => htmlspecialchars($post['remark']),
        ];
        $this->db->where('category_id',  $post['category_id']);
        $this->db->update('cat_expenditure', $params);
    }

    public function delete($expenditure_id)
    {
        $this->db->where('expenditure_id', $expenditure_id);
        $this->db->delete('expenditure');
    }
    public function deletecategory($category_id)
    {
        $this->db->where('category_id', $category_id);
        $this->db->delete('cat_expenditure');
    }
    public function getFilter($post)
    {
        $this->db->select('*');
        $this->db->from('expenditure');
        if (!empty($post['tanggal']) && !empty($post['tanggal2'])) {
            $this->db->where("expenditure.date_payment BETWEEN '" . ($post['tanggal']) . "' AND '" . ($post['tanggal2']) . "'");
        }
        if ($post['category'] !== '') {
            $this->db->where('category', $post['category']);
        }
        $this->db->order_by('date_payment', 'ASC');
        $query = $this->db->get();
        return $query;
    }

    public function deleteselected($expenditure_id)
    {
        $this->db->where_in('expenditure_id', $expenditure_id);
        $this->db->delete('expenditure');
    }

    public function getFilterMonth($post)
    {
        $this->db->select('*');
        $this->db->from('expenditure');

        $this->db->where('MONTH(date_payment)', $post['month']);
        $this->db->where('YEAR(date_payment)', $post['year']);
        if ($post['category'] !== '') {
            $this->db->where('category', $post['category']);
        }
        $this->db->order_by('date_payment', 'ASC');
        $query = $this->db->get();
        return $query;
    }
}
