  <!-- bootstrap datepicker -->
  <link rel="stylesheet" href="<?= base_url('assets/backend') ?>/bootstrap-datepicker/css/bootstrap-datepicker.min.css">
  <style>
      #map-canvas {
          width: 100%;
          height: 400px;
          border: solid #999 1px;
      }

      select {
          width: 240px;
      }

      #kab_box,
      #kec_box,
      #kel_box,
      #kab_boxx,
      #kec_boxx,
      #kel_boxx,
      #lat_box,
      #lng_box {
          display: none;
      }
  </style>
  <!-- Page Heading -->

  <div class="d-sm-flex align-items-center justify-content-between mb-4">
      <?php $role = $this->db->get_where('role_management', ['role_id' => $this->session->userdata('role_id')])->row_array() ?>
      <?php if ($this->session->userdata('role_id') == 1 or $role['add_coverage'] == 1) { ?>
          <a href="" data-toggle="modal" data-target="#add" class="d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i class="fas fa-plus fa-sm text-white-50"></i> Tambah</a>
      <?php } ?>
  </div>
  <?php $this->view('messages') ?>

  <!-- DataTales Example -->
  <div class="card shadow mb-4">
      <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold">Data Coverage</h6>
      </div>
      <div class="container mt-2"> A : Active <br> N-A : Non-Active <br> M : Menunggu</div>
      <div class="card-body">
          <div class="table-responsive">
              <table class="table table-bordered" width="100%" cellspacing="0">
                  <thead>
                      <tr style="text-align: center">
                          <th style="text-align: center; width:20px">No</th>

                          <th style="text-align: center; width:100px">Aksi</th>

                          <th>Nama Area</th>
                          <th>Pelanggan</th>
                          <th>Alamat</th>
                          <th>Keterangan</th>
                      </tr>
                  </thead>

                  <tbody>
                      <?php $no = 1;
                        foreach ($coverage as $r => $data) { ?>
                          <tr>
                              <td style="text-align: center"><?= $no++ ?>.</td>

                              <td style="text-align: center">
                                  <?php if ($this->session->userdata('role_id') == 1 or $role['edit_coverage'] == 1) { ?>
                                      <a href="<?= site_url('coverage/edit/' . $data->coverage_id) ?>" title="Edit"><i class="fa fa-edit" style="font-size:25px"></i>
                                      <?php } ?>
                                      <?php if ($this->session->userdata('role_id') == 1 or $role['del_coverage'] == 1) { ?>
                                      </a> <a href="" data-toggle="modal" data-target="#delete<?= $data->coverage_id ?>" title="Hapus"><i class="fa fa-trash" style="font-size:25px; color:red"></i></a>
                                  <?php } ?>
                              </td>

                              <td>
                                  <a href="<?= site_url('coverage/cs/' . $data->coverage_id) ?>" class="badge badge-primary"><?= $data->c_name; ?></a>
                              </td>
                              <?php $active = $this->db->get_where('customer', ['coverage' => $data->coverage_id, 'c_status' => 'Aktif'])->num_rows(); ?>
                              <?php $nonactive = $this->db->get_where('customer', ['coverage' => $data->coverage_id, 'c_status' => 'Non-Aktif'])->num_rows(); ?>
                              <?php $waiting = $this->db->get_where('customer', ['coverage' => $data->coverage_id, 'c_status' => 'Menunggu'])->num_rows(); ?>
                              <th>A : <?= $active; ?> <br>N-A : <?= $nonactive; ?> <br>M : <?= $waiting; ?></th>
                              <td><?= ucwords(strtolower($data->address)); ?></td>
                              <td><?= $data->comment; ?> </td>
                          </tr>
                      <?php } ?>
                  </tbody>
              </table>
          </div>
      </div>
  </div>
  <script type="text/javascript" src="<?= base_url('assets/backend/') ?>ajax_daerah.js"></script>
  <!-- Modal Add -->
  <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title" id="exampleModalLabel">Tambah Coverage Area</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
              <div class="modal-body">
                  <form action="<?= site_url('coverage/add') ?>" method="POST">

                      <div class="form-group">
                          <label for="name">Nama Area / Code Area</label>
                          <input type="text" name="name" id="name" class="form-control" autocapitalize="off" required>
                      </div>
                      <div class="form-group">
                          <label for="address">Alamat</label>
                          <input type="text" name="address" id="address" class="form-control" autocapitalize="off">
                      </div>

                      <div class="form-group">
                          <label for="comment">Keterangan</label>
                          <input type="text" name="comment" id="comment" class="form-control" autocapitalize="off" autocomplete="off">
                      </div>
              </div>
              <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                  <button type="submit" class="btn btn-primary">Simpan</button>
              </div>
              </form>
          </div>
      </div>
  </div>



  <!-- Modal Edit -->
  <?php foreach ($coverage as $r => $data) { ?>
      <div class="modal fade" id="delete<?= $data->coverage_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog" role="document">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title" id="exampleModalLabel">Hapus Data Coverage</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body">
                      <form action="<?= site_url('coverage/deletecoverage') ?>" method="POST">
                          <input type="hidden" name="coverage_id" value="<?= $data->coverage_id ?>">
                          Apakah anda yakin akan hapus data coverage <?= $data->c_name ?> ?
                  </div>
                  <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                      <button type="submit" class="btn btn-danger">Hapus</button>
                  </div>
                  </form>
              </div>
          </div>
      </div>
  <?php } ?>
  <!-- bootstrap datepicker -->
  <script src="<?= base_url('assets/backend') ?>/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
  <script>
      $(function() {
          //Initialize Select2 Elements
          $('.select2').select2()
      });
      //Date picker
      $('#datepicker').datepicker({
          format: 'yyyy-mm-dd',
          autoclose: true,
          todayHighlight: true,
      })
  </script>



  </html>