<?php $router = $this->db->get('router')->row_array();
$ip = $router['ip_address'];
$username = $router['username'];
$password = $router['password'];
$port = $router['port'];
$API = new Mikweb();
$usermikrotik = $customer['user_mikrotik'];
$API->connect($ip, $username, $password, $port);

// HOTSPOT
$userhotspot = $API->comm("/ip/hotspot/user/print", array("?name" => $usermikrotik));
$hotspotactive = $API->comm("/ip/hotspot/active/print", array("?user" => $usermikrotik));
$usage = $userhotspot['0']['bytes-out'] + $userhotspot['0']['bytes-in'];
// var_dump($userhotspot);

// CONVERT Byte
function formatBytes($size, $precision = 2)
{
    $base = log($size, 1024);
    $suffixes = array('', 'Kb', 'Mb', 'Gb', 'Tb');
    return round(pow(1024, $base - floor($base)), $precision) . ' ' . $suffixes[floor($base)];
}

?>



<!-- TAMPILAN -->
<div class="col-lg-6">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold">Detail Pelanggan <?= $customer['name']; ?> - <?= $customer['no_services']; ?></h6>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card-body">
                    <div class="row">
                        <div class="col">Mode </div>
                        <div class="col">: <?= $customer['mode_user']; ?></div>
                    </div>
                    <div class="row">
                        <div class="col">User </div>
                        <div class="col">: <?= $customer['user_mikrotik']; ?></div>
                    </div>
                    <?php if ($customer['mode_user'] == 'Hotspot') { ?>
                        <div class="row">
                            <div class="col">Pemakaian Internet </div>
                            <div class="col">: <?= formatBytes($usage, 2); ?></div>
                        </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col">Status </div>
                        <div class="col">:
                            <?php if ($customer['mode_user'] == 'Hotspot') { ?>
                                <?php if ($userhotspot['0']['disabled'] == 'true') {
                                    echo 'Isolir';
                                } elseif (count($hotspotactive) > 0) {
                                    echo 'Aktif';
                                } else {
                                    echo 'Non-Aktif';
                                } ?>
                                <?php $idhotspot = str_replace('*', '', $userhotspot['0']['.id']) ?>
                                <?php if ($userhotspot['0']['disabled'] == 'true') { ?>
                                    <a href="<?= site_url('router/openisolirhotspot/' . $idhotspot) ?>" class="btn btn-primary">Open Isolir</a>
                                <?php } ?>
                                <?php if ($userhotspot['0']['disabled'] == 'false') { ?>
                                    <a href="<?= site_url('router/isolirhotspot/' . $idhotspot) ?>" class="btn btn-danger">Isolir User</a>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>